/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ClusterStatistics;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.Profile;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public class SearchResponse<TDocument>
implements JsonpSerializable {
    private final long took;
    private final boolean timedOut;
    private final ShardStatistics shards;
    private final HitsMetadata<TDocument> hits;
    @Nullable
    private final Map<String, JsonValue> aggregations;
    @Nullable
    private final ClusterStatistics clusters;
    @Nullable
    private final List<TDocument> documents;
    @Nullable
    private final Map<String, JsonData> fields;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final Long numReducePhases;
    @Nullable
    private final Profile profile;
    @Nullable
    private final String pitId;
    @Nullable
    private final String scrollId;
    @Nullable
    private final Map<String, List<Suggestion<TDocument>>> suggest;
    @Nullable
    private final Boolean terminatedEarly;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public SearchResponse(AbstractBuilder<TDocument, ?> builder) {
        this.took = Objects.requireNonNull(((AbstractBuilder)builder).took, "took");
        this.timedOut = Objects.requireNonNull(((AbstractBuilder)builder).timedOut, "timed_out");
        this.shards = Objects.requireNonNull(((AbstractBuilder)builder).shards, "_shards");
        this.hits = Objects.requireNonNull(((AbstractBuilder)builder).hits, "hits");
        this.aggregations = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).aggregations);
        this.clusters = ((AbstractBuilder)builder).clusters;
        this.documents = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).documents);
        this.fields = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.maxScore = ((AbstractBuilder)builder).maxScore;
        this.numReducePhases = ((AbstractBuilder)builder).numReducePhases;
        this.profile = ((AbstractBuilder)builder).profile;
        this.pitId = ((AbstractBuilder)builder).pitId;
        this.scrollId = ((AbstractBuilder)builder).scrollId;
        this.suggest = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).suggest);
        this.terminatedEarly = ((AbstractBuilder)builder).terminatedEarly;
        this.tDocumentSerializer = ((AbstractBuilder)builder).tDocumentSerializer;
    }

    public long took() {
        return this.took;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    public HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    @Nullable
    public Map<String, JsonValue> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public ClusterStatistics clusters() {
        return this.clusters;
    }

    @Nullable
    public List<TDocument> documents() {
        return this.documents;
    }

    @Nullable
    public Map<String, JsonData> fields() {
        return this.fields;
    }

    @Nullable
    public Double maxScore() {
        return this.maxScore;
    }

    @Nullable
    public Long numReducePhases() {
        return this.numReducePhases;
    }

    @Nullable
    public Profile profile() {
        return this.profile;
    }

    @Nullable
    public String pitId() {
        return this.pitId;
    }

    @Nullable
    public String scrollId() {
        return this.scrollId;
    }

    @Nullable
    public Map<String, List<Suggestion<TDocument>>> suggest() {
        return this.suggest;
    }

    @Nullable
    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, JsonValue> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.clusters != null) {
            generator.writeKey("_clusters");
            this.clusters.serialize(generator, mapper);
        }
        if (this.documents != null) {
            generator.writeKey("documents");
            generator.writeStartArray();
            for (Map.Entry<String, Object> entry : this.documents) {
                JsonpUtils.serialize(entry, generator, this.tDocumentSerializer, mapper);
            }
            generator.writeEnd();
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
        if (this.numReducePhases != null) {
            generator.writeKey("num_reduce_phases");
            generator.write(this.numReducePhases.longValue());
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            this.profile.serialize(generator, mapper);
        }
        if (this.pitId != null) {
            generator.writeKey("pit_id");
            generator.write(this.pitId);
        }
        if (this.scrollId != null) {
            generator.writeKey("_scroll_id");
            generator.write(this.scrollId);
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.suggest.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                for (Suggestion item1 : (List)entry.getValue()) {
                    item1.serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly.booleanValue());
        }
    }

    public static <TDocument> JsonpDeserializer<SearchResponse<TDocument>> createSearchResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> SearchResponse.setupSearchResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupSearchResponseDeserializer(DelegatingDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(AbstractBuilder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(AbstractBuilder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(AbstractBuilder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits", new String[0]);
        op.add(AbstractBuilder::aggregations, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.jsonValueDeserializer()), "aggregations", new String[0]);
        op.add(AbstractBuilder::clusters, ClusterStatistics._DESERIALIZER, "_clusters", new String[0]);
        op.add(AbstractBuilder::documents, JsonpDeserializer.arrayDeserializer(tDocumentDeserializer), "documents", new String[0]);
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields", new String[0]);
        op.add(AbstractBuilder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score", new String[0]);
        op.add(AbstractBuilder::numReducePhases, JsonpDeserializer.longDeserializer(), "num_reduce_phases", new String[0]);
        op.add(AbstractBuilder::profile, Profile._DESERIALIZER, "profile", new String[0]);
        op.add(AbstractBuilder::pitId, JsonpDeserializer.stringDeserializer(), "pit_id", new String[0]);
        op.add(AbstractBuilder::scrollId, JsonpDeserializer.stringDeserializer(), "_scroll_id", new String[0]);
        op.add(AbstractBuilder::suggest, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(Suggestion.createSuggestionDeserializer(tDocumentDeserializer))), "suggest", new String[0]);
        op.add(AbstractBuilder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early", new String[0]);
    }

    protected static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> {
        private Long took;
        private Boolean timedOut;
        private ShardStatistics shards;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Map<String, JsonValue> aggregations;
        @Nullable
        private ClusterStatistics clusters;
        @Nullable
        private List<TDocument> documents;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private Double maxScore;
        @Nullable
        private Long numReducePhases;
        @Nullable
        private Profile profile;
        @Nullable
        private String pitId;
        @Nullable
        private String scrollId;
        @Nullable
        private Map<String, List<Suggestion<TDocument>>> suggest;
        @Nullable
        private Boolean terminatedEarly;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        protected AbstractBuilder() {
        }

        public BuilderT took(long value) {
            this.took = value;
            return this.self();
        }

        public BuilderT timedOut(boolean value) {
            this.timedOut = value;
            return this.self();
        }

        public BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return this.self();
        }

        public BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public BuilderT hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this.self();
        }

        public BuilderT hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public BuilderT aggregations(@Nullable Map<String, JsonValue> value) {
            this.aggregations = value;
            return this.self();
        }

        public BuilderT putAggregations(String key, JsonValue value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, JsonValue>();
            }
            this.aggregations.put(key, value);
            return this.self();
        }

        public BuilderT clusters(@Nullable ClusterStatistics value) {
            this.clusters = value;
            return this.self();
        }

        public BuilderT clusters(Function<ClusterStatistics.Builder, ObjectBuilder<ClusterStatistics>> fn) {
            return this.clusters(fn.apply(new ClusterStatistics.Builder()).build());
        }

        public BuilderT documents(@Nullable List<TDocument> value) {
            this.documents = value;
            return this.self();
        }

        public BuilderT documents(TDocument ... value) {
            this.documents = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addDocuments(TDocument value) {
            if (this.documents == null) {
                this.documents = new ArrayList<TDocument>();
            }
            this.documents.add(value);
            return this.self();
        }

        public BuilderT fields(@Nullable Map<String, JsonData> value) {
            this.fields = value;
            return this.self();
        }

        public BuilderT putFields(String key, JsonData value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, JsonData>();
            }
            this.fields.put(key, value);
            return this.self();
        }

        public BuilderT maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this.self();
        }

        public BuilderT numReducePhases(@Nullable Long value) {
            this.numReducePhases = value;
            return this.self();
        }

        public BuilderT profile(@Nullable Profile value) {
            this.profile = value;
            return this.self();
        }

        public BuilderT profile(Function<Profile.Builder, ObjectBuilder<Profile>> fn) {
            return this.profile(fn.apply(new Profile.Builder()).build());
        }

        public BuilderT pitId(@Nullable String value) {
            this.pitId = value;
            return this.self();
        }

        public BuilderT scrollId(@Nullable String value) {
            this.scrollId = value;
            return this.self();
        }

        public BuilderT suggest(@Nullable Map<String, List<Suggestion<TDocument>>> value) {
            this.suggest = value;
            return this.self();
        }

        public BuilderT putSuggest(String key, List<Suggestion<TDocument>> value) {
            if (this.suggest == null) {
                this.suggest = new HashMap<String, List<Suggestion<TDocument>>>();
            }
            this.suggest.put(key, value);
            return this.self();
        }

        public BuilderT terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return this.self();
        }

        public BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder<TDocument>
    extends AbstractBuilder<TDocument, Builder<TDocument>>
    implements ObjectBuilder<SearchResponse<TDocument>> {
        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public SearchResponse<TDocument> build() {
            return new SearchResponse(this);
        }
    }
}

