/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchMvtResponse;
import co.elastic.clients.elasticsearch.core.search_mvt.GridType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SearchMvtRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> index;
    private final String field;
    private final int zoom;
    private final int x;
    private final int y;
    @Nullable
    private final Map<String, Aggregation> aggs;
    @Nullable
    private final Boolean exactBounds;
    @Nullable
    private final Integer extent;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Integer gridPrecision;
    @Nullable
    private final GridType gridType;
    @Nullable
    private final Query query;
    @Nullable
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final Integer size;
    @Nullable
    private final List<JsonValue> sort;
    public static final JsonpDeserializer<SearchMvtRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchMvtRequest::setupSearchMvtRequestDeserializer, Builder::build);
    public static final Endpoint<SearchMvtRequest, SearchMvtResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<SearchMvtRequest, SearchMvtResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _field = 2;
        int _zoom = 4;
        int _x = 8;
        int _y = 16;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        propsSet |= 4;
        propsSet |= 8;
        if ((propsSet |= 0x10) == 31) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mvt");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.field, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(String.valueOf(request.zoom), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(String.valueOf(request.x), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(String.valueOf(request.y), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap params = new HashMap();
        return params;
    }, SimpleEndpoint.emptyMap(), true, SearchMvtResponse._DESERIALIZER);

    public SearchMvtRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.zoom = Objects.requireNonNull(builder.zoom, "zoom");
        this.x = Objects.requireNonNull(builder.x, "x");
        this.y = Objects.requireNonNull(builder.y, "y");
        this.aggs = ModelTypeHelper.unmodifiable(builder.aggs);
        this.exactBounds = builder.exactBounds;
        this.extent = builder.extent;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.gridPrecision = builder.gridPrecision;
        this.gridType = builder.gridType;
        this.query = builder.query;
        this.runtimeMappings = ModelTypeHelper.unmodifiable(builder.runtimeMappings);
        this.size = builder.size;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
    }

    public SearchMvtRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    public String field() {
        return this.field;
    }

    public int zoom() {
        return this.zoom;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    @Nullable
    public Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Nullable
    public Boolean exactBounds() {
        return this.exactBounds;
    }

    @Nullable
    public Integer extent() {
        return this.extent;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Integer gridPrecision() {
        return this.gridPrecision;
    }

    @Nullable
    public GridType gridType() {
        return this.gridType;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggs != null) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggs.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.exactBounds != null) {
            generator.writeKey("exact_bounds");
            generator.write(this.exactBounds.booleanValue());
        }
        if (this.extent != null) {
            generator.writeKey("extent");
            generator.write(this.extent.intValue());
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.gridPrecision != null) {
            generator.writeKey("grid_precision");
            generator.write(this.gridPrecision.intValue());
        }
        if (this.gridType != null) {
            generator.writeKey("grid_type");
            this.gridType.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.runtimeMappings != null) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSearchMvtRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggs, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggs", new String[0]);
        op.add(Builder::exactBounds, JsonpDeserializer.booleanDeserializer(), "exact_bounds", new String[0]);
        op.add(Builder::extent, JsonpDeserializer.integerDeserializer(), "extent", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::gridPrecision, JsonpDeserializer.integerDeserializer(), "grid_precision", new String[0]);
        op.add(Builder::gridType, GridType._DESERIALIZER, "grid_type", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SearchMvtRequest> {
        private List<String> index;
        private String field;
        private Integer zoom;
        private Integer x;
        private Integer y;
        @Nullable
        private Map<String, Aggregation> aggs;
        @Nullable
        private Boolean exactBounds;
        @Nullable
        private Integer extent;
        @Nullable
        private List<String> fields;
        @Nullable
        private Integer gridPrecision;
        @Nullable
        private GridType gridType;
        @Nullable
        private Query query;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Integer size;
        @Nullable
        private List<JsonValue> sort;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder zoom(int value) {
            this.zoom = value;
            return this;
        }

        public Builder x(int value) {
            this.x = value;
            return this;
        }

        public Builder y(int value) {
            this.y = value;
            return this;
        }

        public Builder aggs(@Nullable Map<String, Aggregation> value) {
            this.aggs = value;
            return this;
        }

        public Builder putAggs(String key, Aggregation value) {
            if (this.aggs == null) {
                this.aggs = new HashMap<String, Aggregation>();
            }
            this.aggs.put(key, value);
            return this;
        }

        public Builder aggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggs(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder exactBounds(@Nullable Boolean value) {
            this.exactBounds = value;
            return this;
        }

        public Builder extent(@Nullable Integer value) {
            this.extent = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder gridPrecision(@Nullable Integer value) {
            this.gridPrecision = value;
            return this;
        }

        public Builder gridType(@Nullable GridType value) {
            this.gridType = value;
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder runtimeMappings(@Nullable Map<String, RuntimeField> value) {
            this.runtimeMappings = value;
            return this;
        }

        public Builder putRuntimeMappings(String key, RuntimeField value) {
            if (this.runtimeMappings == null) {
                this.runtimeMappings = new HashMap<String, RuntimeField>();
            }
            this.runtimeMappings.put(key, value);
            return this;
        }

        public Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        @Override
        public SearchMvtRequest build() {
            return new SearchMvtRequest(this);
        }
    }
}

