/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MsearchResponse<TDocument>
implements JsonpSerializable {
    private final long took;
    private final List<JsonValue> responses;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public MsearchResponse(Builder<TDocument> builder) {
        this.took = Objects.requireNonNull(((Builder)builder).took, "took");
        this.responses = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).responses, "responses");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public MsearchResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public long took() {
        return this.took;
    }

    public List<JsonValue> responses() {
        return this.responses;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("responses");
        generator.writeStartArray();
        for (JsonValue item0 : this.responses) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    public static <TDocument> JsonpDeserializer<MsearchResponse<TDocument>> createMsearchResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> MsearchResponse.setupMsearchResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupMsearchResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(Builder::responses, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "responses", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<MsearchResponse<TDocument>> {
        private Long took;
        private List<JsonValue> responses;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> took(long value) {
            this.took = value;
            return this;
        }

        public Builder<TDocument> responses(List<JsonValue> value) {
            this.responses = value;
            return this;
        }

        public Builder<TDocument> responses(JsonValue ... value) {
            this.responses = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addResponses(JsonValue value) {
            if (this.responses == null) {
                this.responses = new ArrayList<JsonValue>();
            }
            this.responses.add(value);
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public MsearchResponse<TDocument> build() {
            return new MsearchResponse(this);
        }
    }
}

