/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch.core.MsearchResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MsearchRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<String> type;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Long maxConcurrentSearches;
    @Nullable
    private final Long maxConcurrentShardRequests;
    @Nullable
    private final Long preFilterShardSize;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Boolean typedKeys;
    private final List<JsonValue> searches;
    public static final JsonpDeserializer<MsearchRequest> _DESERIALIZER = MsearchRequest.createMsearchRequestDeserializer();
    private static final SimpleEndpoint<MsearchRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_msearch");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_msearch");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_msearch");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.maxConcurrentSearches != null) {
            params.put("max_concurrent_searches", String.valueOf(request.maxConcurrentSearches));
        }
        if (request.maxConcurrentShardRequests != null) {
            params.put("max_concurrent_shard_requests", String.valueOf(request.maxConcurrentShardRequests));
        }
        if (request.preFilterShardSize != null) {
            params.put("pre_filter_shard_size", String.valueOf(request.preFilterShardSize));
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.toString());
        }
        if (request.typedKeys != null) {
            params.put("typed_keys", String.valueOf(request.typedKeys));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public MsearchRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.type = ModelTypeHelper.unmodifiable(builder.type);
        this.allowNoIndices = builder.allowNoIndices;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.maxConcurrentSearches = builder.maxConcurrentSearches;
        this.maxConcurrentShardRequests = builder.maxConcurrentShardRequests;
        this.preFilterShardSize = builder.preFilterShardSize;
        this.searchType = builder.searchType;
        this.typedKeys = builder.typedKeys;
        this.searches = ModelTypeHelper.unmodifiableNonNull(builder.searches, "_value_body");
    }

    public MsearchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> type() {
        return this.type;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Long maxConcurrentSearches() {
        return this.maxConcurrentSearches;
    }

    @Nullable
    public Long maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Nullable
    public Long preFilterShardSize() {
        return this.preFilterShardSize;
    }

    @Nullable
    public SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public Boolean typedKeys() {
        return this.typedKeys;
    }

    public List<JsonValue> searches() {
        return this.searches;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (JsonValue item0 : this.searches) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<MsearchRequest> createMsearchRequestDeserializer() {
        JsonpDeserializer<List<JsonValue>> valueDeserializer = JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer());
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().searches((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static <TDocument> Endpoint<MsearchRequest, MsearchResponse<TDocument>, ElasticsearchError> createMsearchEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(MsearchResponse.createMsearchResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<MsearchRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> type;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Long maxConcurrentSearches;
        @Nullable
        private Long maxConcurrentShardRequests;
        @Nullable
        private Long preFilterShardSize;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Boolean typedKeys;
        private List<JsonValue> searches;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder maxConcurrentSearches(@Nullable Long value) {
            this.maxConcurrentSearches = value;
            return this;
        }

        public Builder maxConcurrentShardRequests(@Nullable Long value) {
            this.maxConcurrentShardRequests = value;
            return this;
        }

        public Builder preFilterShardSize(@Nullable Long value) {
            this.preFilterShardSize = value;
            return this;
        }

        public Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public Builder typedKeys(@Nullable Boolean value) {
            this.typedKeys = value;
            return this;
        }

        public Builder searches(List<JsonValue> value) {
            this.searches = value;
            return this;
        }

        public Builder searches(JsonValue ... value) {
            this.searches = Arrays.asList(value);
            return this;
        }

        public Builder addSearches(JsonValue value) {
            if (this.searches == null) {
                this.searches = new ArrayList<JsonValue>();
            }
            this.searches.add(value);
            return this;
        }

        @Override
        public MsearchRequest build() {
            return new MsearchRequest(this);
        }
    }
}

