/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ElasticsearchVersionInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class InfoResponse
implements JsonpSerializable {
    private final String clusterName;
    private final String clusterUuid;
    private final String name;
    private final String tagline;
    private final ElasticsearchVersionInfo version;
    public static final JsonpDeserializer<InfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InfoResponse::setupInfoResponseDeserializer, Builder::build);

    public InfoResponse(Builder builder) {
        this.clusterName = Objects.requireNonNull(builder.clusterName, "cluster_name");
        this.clusterUuid = Objects.requireNonNull(builder.clusterUuid, "cluster_uuid");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.tagline = Objects.requireNonNull(builder.tagline, "tagline");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public InfoResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String clusterUuid() {
        return this.clusterUuid;
    }

    public String name() {
        return this.name;
    }

    public String tagline() {
        return this.tagline;
    }

    public ElasticsearchVersionInfo version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("cluster_uuid");
        generator.write(this.clusterUuid);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("tagline");
        generator.write(this.tagline);
        generator.writeKey("version");
        this.version.serialize(generator, mapper);
    }

    protected static void setupInfoResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name", new String[0]);
        op.add(Builder::clusterUuid, JsonpDeserializer.stringDeserializer(), "cluster_uuid", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::tagline, JsonpDeserializer.stringDeserializer(), "tagline", new String[0]);
        op.add(Builder::version, ElasticsearchVersionInfo._DESERIALIZER, "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InfoResponse> {
        private String clusterName;
        private String clusterUuid;
        private String name;
        private String tagline;
        private ElasticsearchVersionInfo version;

        public Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public Builder clusterUuid(String value) {
            this.clusterUuid = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder tagline(String value) {
            this.tagline = value;
            return this;
        }

        public Builder version(ElasticsearchVersionInfo value) {
            this.version = value;
            return this;
        }

        public Builder version(Function<ElasticsearchVersionInfo.Builder, ObjectBuilder<ElasticsearchVersionInfo>> fn) {
            return this.version(fn.apply(new ElasticsearchVersionInfo.Builder()).build());
        }

        @Override
        public InfoResponse build() {
            return new InfoResponse(this);
        }
    }
}

