/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class IndexRequest<TDocument>
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Integer ifSeqNo;
    @Nullable
    private final OpType opType;
    @Nullable
    private final String pipeline;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final String timeout;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final Boolean requireAlias;
    private final TDocument document;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final Endpoint<IndexRequest<?>, IndexResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<IndexRequest, IndexResponse>(request -> {
        boolean _id = true;
        int _index = 2;
        int _type = 4;
        int propsSet = 0;
        if (request.id() != null) {
            propsSet |= 1;
        }
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            return "PUT";
        }
        if (propsSet == 2) {
            return "POST";
        }
        if (propsSet == 6) {
            return "POST";
        }
        if (propsSet == 7) {
            return "PUT";
        }
        throw SimpleEndpoint.noPathTemplateFound("method");
    }, request -> {
        boolean _id = true;
        int _index = 2;
        int _type = 4;
        int propsSet = 0;
        if (request.id() != null) {
            propsSet |= 1;
        }
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            return buf.toString();
        }
        if (propsSet == 6) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.opType != null) {
            params.put("op_type", request.opType.toString());
        }
        if (request.pipeline != null) {
            params.put("pipeline", request.pipeline);
        }
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.toString());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, IndexResponse._DESERIALIZER);

    public IndexRequest(Builder<TDocument> builder) {
        this.id = ((Builder)builder).id;
        this.index = Objects.requireNonNull(((Builder)builder).index, "index");
        this.type = ((Builder)builder).type;
        this.ifPrimaryTerm = ((Builder)builder).ifPrimaryTerm;
        this.ifSeqNo = ((Builder)builder).ifSeqNo;
        this.opType = ((Builder)builder).opType;
        this.pipeline = ((Builder)builder).pipeline;
        this.refresh = ((Builder)builder).refresh;
        this.routing = ((Builder)builder).routing;
        this.timeout = ((Builder)builder).timeout;
        this.version = ((Builder)builder).version;
        this.versionType = ((Builder)builder).versionType;
        this.waitForActiveShards = ((Builder)builder).waitForActiveShards;
        this.requireAlias = ((Builder)builder).requireAlias;
        this.document = Objects.requireNonNull(((Builder)builder).document, "_value_body");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public IndexRequest(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public Integer ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public OpType opType() {
        return this.opType;
    }

    @Nullable
    public String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public Boolean requireAlias() {
        return this.requireAlias;
    }

    public TDocument document() {
        return this.document;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        JsonpUtils.serialize(this.document, generator, this.tDocumentSerializer, mapper);
    }

    public static <TDocument> JsonpDeserializer<IndexRequest<TDocument>> createIndexRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        JsonpDeserializer valueDeserializer = tDocumentDeserializer;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().document(valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<IndexRequest<TDocument>> {
        @Nullable
        private String id;
        private String index;
        @Nullable
        private String type;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Integer ifSeqNo;
        @Nullable
        private OpType opType;
        @Nullable
        private String pipeline;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private String routing;
        @Nullable
        private String timeout;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private Boolean requireAlias;
        private TDocument document;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<TDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TDocument> ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public Builder<TDocument> ifSeqNo(@Nullable Integer value) {
            this.ifSeqNo = value;
            return this;
        }

        public Builder<TDocument> opType(@Nullable OpType value) {
            this.opType = value;
            return this;
        }

        public Builder<TDocument> pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public Builder<TDocument> refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder<TDocument> timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder<TDocument> versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public Builder<TDocument> waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder<TDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public Builder<TDocument> document(TDocument value) {
            this.document = value;
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public IndexRequest<TDocument> build() {
            return new IndexRequest(this);
        }
    }
}

