/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetSourceResponse<TDocument>
implements JsonpSerializable {
    private final TDocument valueBody;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public GetSourceResponse(Builder<TDocument> builder) {
        this.valueBody = Objects.requireNonNull(((Builder)builder).valueBody, "_value_body");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public GetSourceResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public TDocument valueBody() {
        return this.valueBody;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        JsonpUtils.serialize(this.valueBody, generator, this.tDocumentSerializer, mapper);
    }

    public static <TDocument> JsonpDeserializer<GetSourceResponse<TDocument>> createGetSourceResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        JsonpDeserializer valueDeserializer = tDocumentDeserializer;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().valueBody(valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<GetSourceResponse<TDocument>> {
        private TDocument valueBody;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> valueBody(TDocument value) {
            this.valueBody = value;
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public GetSourceResponse<TDocument> build() {
            return new GetSourceResponse(this);
        }
    }
}

