/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetResponse<TDocument>
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final Map<String, JsonData> fields;
    private final boolean found;
    private final String id;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final String routing;
    @Nullable
    private final Integer seqNo;
    @Nullable
    private final TDocument source;
    @Nullable
    private final String type;
    @Nullable
    private final Long version;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public GetResponse(Builder<TDocument> builder) {
        this.index = Objects.requireNonNull(((Builder)builder).index, "_index");
        this.fields = ModelTypeHelper.unmodifiable(((Builder)builder).fields);
        this.found = Objects.requireNonNull(((Builder)builder).found, "found");
        this.id = Objects.requireNonNull(((Builder)builder).id, "_id");
        this.primaryTerm = ((Builder)builder).primaryTerm;
        this.routing = ((Builder)builder).routing;
        this.seqNo = ((Builder)builder).seqNo;
        this.source = ((Builder)builder).source;
        this.type = ((Builder)builder).type;
        this.version = ((Builder)builder).version;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public GetResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Map<String, JsonData> fields() {
        return this.fields;
    }

    public boolean found() {
        return this.found;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public Integer seqNo() {
        return this.seqNo;
    }

    @Nullable
    public TDocument source() {
        return this.source;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.intValue());
        }
        if (this.source != null) {
            generator.writeKey("_source");
            JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
        }
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
    }

    public static <TDocument> JsonpDeserializer<GetResponse<TDocument>> createGetResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> GetResponse.setupGetResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupGetResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields", new String[0]);
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing", new String[0]);
        op.add(Builder::seqNo, JsonpDeserializer.integerDeserializer(), "_seq_no", new String[0]);
        op.add(Builder::source, tDocumentDeserializer, "_source", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<GetResponse<TDocument>> {
        private String index;
        @Nullable
        private Map<String, JsonData> fields;
        private Boolean found;
        private String id;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private String routing;
        @Nullable
        private Integer seqNo;
        @Nullable
        private TDocument source;
        @Nullable
        private String type;
        @Nullable
        private Long version;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<TDocument> fields(@Nullable Map<String, JsonData> value) {
            this.fields = value;
            return this;
        }

        public Builder<TDocument> putFields(String key, JsonData value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, JsonData>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder<TDocument> found(boolean value) {
            this.found = value;
            return this;
        }

        public Builder<TDocument> id(String value) {
            this.id = value;
            return this;
        }

        public Builder<TDocument> primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return this;
        }

        public Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder<TDocument> seqNo(@Nullable Integer value) {
            this.seqNo = value;
            return this;
        }

        public Builder<TDocument> source(@Nullable TDocument value) {
            this.source = value;
            return this;
        }

        public Builder<TDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public GetResponse<TDocument> build() {
            return new GetResponse(this);
        }
    }
}

