/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch._types.PluginStats;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterFileSystem;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterIngest;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterJvm;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterNetworkTypes;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterNodeCount;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystem;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterProcess;
import co.elastic.clients.elasticsearch.cluster.stats.NodePackagingType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterNodes
implements JsonpSerializable {
    private final ClusterNodeCount count;
    private final Map<String, Integer> discoveryTypes;
    private final ClusterFileSystem fs;
    private final ClusterIngest ingest;
    private final ClusterJvm jvm;
    private final ClusterNetworkTypes networkTypes;
    private final ClusterOperatingSystem os;
    private final List<NodePackagingType> packagingTypes;
    private final List<PluginStats> plugins;
    private final ClusterProcess process;
    private final List<String> versions;
    public static final JsonpDeserializer<ClusterNodes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodes::setupClusterNodesDeserializer, Builder::build);

    public ClusterNodes(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.discoveryTypes = ModelTypeHelper.unmodifiableNonNull(builder.discoveryTypes, "discovery_types");
        this.fs = Objects.requireNonNull(builder.fs, "fs");
        this.ingest = Objects.requireNonNull(builder.ingest, "ingest");
        this.jvm = Objects.requireNonNull(builder.jvm, "jvm");
        this.networkTypes = Objects.requireNonNull(builder.networkTypes, "network_types");
        this.os = Objects.requireNonNull(builder.os, "os");
        this.packagingTypes = ModelTypeHelper.unmodifiableNonNull(builder.packagingTypes, "packaging_types");
        this.plugins = ModelTypeHelper.unmodifiableNonNull(builder.plugins, "plugins");
        this.process = Objects.requireNonNull(builder.process, "process");
        this.versions = ModelTypeHelper.unmodifiableNonNull(builder.versions, "versions");
    }

    public ClusterNodes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ClusterNodeCount count() {
        return this.count;
    }

    public Map<String, Integer> discoveryTypes() {
        return this.discoveryTypes;
    }

    public ClusterFileSystem fs() {
        return this.fs;
    }

    public ClusterIngest ingest() {
        return this.ingest;
    }

    public ClusterJvm jvm() {
        return this.jvm;
    }

    public ClusterNetworkTypes networkTypes() {
        return this.networkTypes;
    }

    public ClusterOperatingSystem os() {
        return this.os;
    }

    public List<NodePackagingType> packagingTypes() {
        return this.packagingTypes;
    }

    public List<PluginStats> plugins() {
        return this.plugins;
    }

    public ClusterProcess process() {
        return this.process;
    }

    public List<String> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        this.count.serialize(generator, mapper);
        generator.writeKey("discovery_types");
        generator.writeStartObject();
        for (Map.Entry<String, Integer> entry : this.discoveryTypes.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue().intValue());
        }
        generator.writeEnd();
        generator.writeKey("fs");
        this.fs.serialize(generator, mapper);
        generator.writeKey("ingest");
        this.ingest.serialize(generator, mapper);
        generator.writeKey("jvm");
        this.jvm.serialize(generator, mapper);
        generator.writeKey("network_types");
        this.networkTypes.serialize(generator, mapper);
        generator.writeKey("os");
        this.os.serialize(generator, mapper);
        generator.writeKey("packaging_types");
        generator.writeStartArray();
        for (NodePackagingType nodePackagingType : this.packagingTypes) {
            nodePackagingType.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("plugins");
        generator.writeStartArray();
        for (PluginStats pluginStats : this.plugins) {
            pluginStats.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("process");
        this.process.serialize(generator, mapper);
        generator.writeKey("versions");
        generator.writeStartArray();
        for (String string : this.versions) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    protected static void setupClusterNodesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, ClusterNodeCount._DESERIALIZER, "count", new String[0]);
        op.add(Builder::discoveryTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "discovery_types", new String[0]);
        op.add(Builder::fs, ClusterFileSystem._DESERIALIZER, "fs", new String[0]);
        op.add(Builder::ingest, ClusterIngest._DESERIALIZER, "ingest", new String[0]);
        op.add(Builder::jvm, ClusterJvm._DESERIALIZER, "jvm", new String[0]);
        op.add(Builder::networkTypes, ClusterNetworkTypes._DESERIALIZER, "network_types", new String[0]);
        op.add(Builder::os, ClusterOperatingSystem._DESERIALIZER, "os", new String[0]);
        op.add(Builder::packagingTypes, JsonpDeserializer.arrayDeserializer(NodePackagingType._DESERIALIZER), "packaging_types", new String[0]);
        op.add(Builder::plugins, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "plugins", new String[0]);
        op.add(Builder::process, ClusterProcess._DESERIALIZER, "process", new String[0]);
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "versions", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterNodes> {
        private ClusterNodeCount count;
        private Map<String, Integer> discoveryTypes;
        private ClusterFileSystem fs;
        private ClusterIngest ingest;
        private ClusterJvm jvm;
        private ClusterNetworkTypes networkTypes;
        private ClusterOperatingSystem os;
        private List<NodePackagingType> packagingTypes;
        private List<PluginStats> plugins;
        private ClusterProcess process;
        private List<String> versions;

        public Builder count(ClusterNodeCount value) {
            this.count = value;
            return this;
        }

        public Builder count(Function<ClusterNodeCount.Builder, ObjectBuilder<ClusterNodeCount>> fn) {
            return this.count(fn.apply(new ClusterNodeCount.Builder()).build());
        }

        public Builder discoveryTypes(Map<String, Integer> value) {
            this.discoveryTypes = value;
            return this;
        }

        public Builder putDiscoveryTypes(String key, Integer value) {
            if (this.discoveryTypes == null) {
                this.discoveryTypes = new HashMap<String, Integer>();
            }
            this.discoveryTypes.put(key, value);
            return this;
        }

        public Builder fs(ClusterFileSystem value) {
            this.fs = value;
            return this;
        }

        public Builder fs(Function<ClusterFileSystem.Builder, ObjectBuilder<ClusterFileSystem>> fn) {
            return this.fs(fn.apply(new ClusterFileSystem.Builder()).build());
        }

        public Builder ingest(ClusterIngest value) {
            this.ingest = value;
            return this;
        }

        public Builder ingest(Function<ClusterIngest.Builder, ObjectBuilder<ClusterIngest>> fn) {
            return this.ingest(fn.apply(new ClusterIngest.Builder()).build());
        }

        public Builder jvm(ClusterJvm value) {
            this.jvm = value;
            return this;
        }

        public Builder jvm(Function<ClusterJvm.Builder, ObjectBuilder<ClusterJvm>> fn) {
            return this.jvm(fn.apply(new ClusterJvm.Builder()).build());
        }

        public Builder networkTypes(ClusterNetworkTypes value) {
            this.networkTypes = value;
            return this;
        }

        public Builder networkTypes(Function<ClusterNetworkTypes.Builder, ObjectBuilder<ClusterNetworkTypes>> fn) {
            return this.networkTypes(fn.apply(new ClusterNetworkTypes.Builder()).build());
        }

        public Builder os(ClusterOperatingSystem value) {
            this.os = value;
            return this;
        }

        public Builder os(Function<ClusterOperatingSystem.Builder, ObjectBuilder<ClusterOperatingSystem>> fn) {
            return this.os(fn.apply(new ClusterOperatingSystem.Builder()).build());
        }

        public Builder packagingTypes(List<NodePackagingType> value) {
            this.packagingTypes = value;
            return this;
        }

        public Builder packagingTypes(NodePackagingType ... value) {
            this.packagingTypes = Arrays.asList(value);
            return this;
        }

        public Builder addPackagingTypes(NodePackagingType value) {
            if (this.packagingTypes == null) {
                this.packagingTypes = new ArrayList<NodePackagingType>();
            }
            this.packagingTypes.add(value);
            return this;
        }

        public Builder packagingTypes(Function<NodePackagingType.Builder, ObjectBuilder<NodePackagingType>> fn) {
            return this.packagingTypes(fn.apply(new NodePackagingType.Builder()).build());
        }

        public Builder addPackagingTypes(Function<NodePackagingType.Builder, ObjectBuilder<NodePackagingType>> fn) {
            return this.addPackagingTypes(fn.apply(new NodePackagingType.Builder()).build());
        }

        public Builder plugins(List<PluginStats> value) {
            this.plugins = value;
            return this;
        }

        public Builder plugins(PluginStats ... value) {
            this.plugins = Arrays.asList(value);
            return this;
        }

        public Builder addPlugins(PluginStats value) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<PluginStats>();
            }
            this.plugins.add(value);
            return this;
        }

        public Builder plugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.plugins(fn.apply(new PluginStats.Builder()).build());
        }

        public Builder addPlugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.addPlugins(fn.apply(new PluginStats.Builder()).build());
        }

        public Builder process(ClusterProcess value) {
            this.process = value;
            return this;
        }

        public Builder process(Function<ClusterProcess.Builder, ObjectBuilder<ClusterProcess>> fn) {
            return this.process(fn.apply(new ClusterProcess.Builder()).build());
        }

        public Builder versions(List<String> value) {
            this.versions = value;
            return this;
        }

        public Builder versions(String ... value) {
            this.versions = Arrays.asList(value);
            return this;
        }

        public Builder addVersions(String value) {
            if (this.versions == null) {
                this.versions = new ArrayList<String>();
            }
            this.versions.add(value);
            return this;
        }

        @Override
        public ClusterNodes build() {
            return new ClusterNodes(this);
        }
    }
}

