/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AllocationStore
implements JsonpSerializable {
    private final String allocationId;
    private final boolean found;
    private final boolean inSync;
    private final long matchingSizeInBytes;
    private final boolean matchingSyncId;
    private final String storeException;
    public static final JsonpDeserializer<AllocationStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationStore::setupAllocationStoreDeserializer, Builder::build);

    public AllocationStore(Builder builder) {
        this.allocationId = Objects.requireNonNull(builder.allocationId, "allocation_id");
        this.found = Objects.requireNonNull(builder.found, "found");
        this.inSync = Objects.requireNonNull(builder.inSync, "in_sync");
        this.matchingSizeInBytes = Objects.requireNonNull(builder.matchingSizeInBytes, "matching_size_in_bytes");
        this.matchingSyncId = Objects.requireNonNull(builder.matchingSyncId, "matching_sync_id");
        this.storeException = Objects.requireNonNull(builder.storeException, "store_exception");
    }

    public AllocationStore(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String allocationId() {
        return this.allocationId;
    }

    public boolean found() {
        return this.found;
    }

    public boolean inSync() {
        return this.inSync;
    }

    public long matchingSizeInBytes() {
        return this.matchingSizeInBytes;
    }

    public boolean matchingSyncId() {
        return this.matchingSyncId;
    }

    public String storeException() {
        return this.storeException;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocation_id");
        generator.write(this.allocationId);
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("in_sync");
        generator.write(this.inSync);
        generator.writeKey("matching_size_in_bytes");
        generator.write(this.matchingSizeInBytes);
        generator.writeKey("matching_sync_id");
        generator.write(this.matchingSyncId);
        generator.writeKey("store_exception");
        generator.write(this.storeException);
    }

    protected static void setupAllocationStoreDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allocationId, JsonpDeserializer.stringDeserializer(), "allocation_id", new String[0]);
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found", new String[0]);
        op.add(Builder::inSync, JsonpDeserializer.booleanDeserializer(), "in_sync", new String[0]);
        op.add(Builder::matchingSizeInBytes, JsonpDeserializer.longDeserializer(), "matching_size_in_bytes", new String[0]);
        op.add(Builder::matchingSyncId, JsonpDeserializer.booleanDeserializer(), "matching_sync_id", new String[0]);
        op.add(Builder::storeException, JsonpDeserializer.stringDeserializer(), "store_exception", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AllocationStore> {
        private String allocationId;
        private Boolean found;
        private Boolean inSync;
        private Long matchingSizeInBytes;
        private Boolean matchingSyncId;
        private String storeException;

        public Builder allocationId(String value) {
            this.allocationId = value;
            return this;
        }

        public Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public Builder inSync(boolean value) {
            this.inSync = value;
            return this;
        }

        public Builder matchingSizeInBytes(long value) {
            this.matchingSizeInBytes = value;
            return this;
        }

        public Builder matchingSyncId(boolean value) {
            this.matchingSyncId = value;
            return this;
        }

        public Builder storeException(String value) {
            this.storeException = value;
            return this;
        }

        @Override
        public AllocationStore build() {
            return new AllocationStore(this);
        }
    }
}

