/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.ComponentTemplateSummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ComponentTemplateNode
implements JsonpSerializable {
    private final ComponentTemplateSummary template;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<ComponentTemplateNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplateNode::setupComponentTemplateNodeDeserializer, Builder::build);

    public ComponentTemplateNode(Builder builder) {
        this.template = Objects.requireNonNull(builder.template, "template");
        this.version = builder.version;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
    }

    public ComponentTemplateNode(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ComponentTemplateSummary template() {
        return this.template;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupComponentTemplateNodeDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::template, ComponentTemplateSummary._DESERIALIZER, "template", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ComponentTemplateNode> {
        private ComponentTemplateSummary template;
        @Nullable
        private Long version;
        @Nullable
        private Map<String, JsonData> meta;

        public Builder template(ComponentTemplateSummary value) {
            this.template = value;
            return this;
        }

        public Builder template(Function<ComponentTemplateSummary.Builder, ObjectBuilder<ComponentTemplateSummary>> fn) {
            return this.template(fn.apply(new ComponentTemplateSummary.Builder()).build());
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        @Override
        public ComponentTemplateNode build() {
            return new ComponentTemplateNode(this);
        }
    }
}

