/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.ComponentTemplateNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ComponentTemplate
implements JsonpSerializable {
    private final String name;
    private final ComponentTemplateNode componentTemplate;
    public static final JsonpDeserializer<ComponentTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplate::setupComponentTemplateDeserializer, Builder::build);

    public ComponentTemplate(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.componentTemplate = Objects.requireNonNull(builder.componentTemplate, "component_template");
    }

    public ComponentTemplate(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public ComponentTemplateNode componentTemplate() {
        return this.componentTemplate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("component_template");
        this.componentTemplate.serialize(generator, mapper);
    }

    protected static void setupComponentTemplateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::componentTemplate, ComponentTemplateNode._DESERIALIZER, "component_template", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ComponentTemplate> {
        private String name;
        private ComponentTemplateNode componentTemplate;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder componentTemplate(ComponentTemplateNode value) {
            this.componentTemplate = value;
            return this;
        }

        public Builder componentTemplate(Function<ComponentTemplateNode.Builder, ObjectBuilder<ComponentTemplateNode>> fn) {
            return this.componentTemplate(fn.apply(new ComponentTemplateNode.Builder()).build());
        }

        @Override
        public ComponentTemplate build() {
            return new ComponentTemplate(this);
        }
    }
}

