/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FollowResponse
implements JsonpSerializable {
    private final boolean followIndexCreated;
    private final boolean followIndexShardsAcked;
    private final boolean indexFollowingStarted;
    public static final JsonpDeserializer<FollowResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowResponse::setupFollowResponseDeserializer, Builder::build);

    public FollowResponse(Builder builder) {
        this.followIndexCreated = Objects.requireNonNull(builder.followIndexCreated, "follow_index_created");
        this.followIndexShardsAcked = Objects.requireNonNull(builder.followIndexShardsAcked, "follow_index_shards_acked");
        this.indexFollowingStarted = Objects.requireNonNull(builder.indexFollowingStarted, "index_following_started");
    }

    public FollowResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean followIndexCreated() {
        return this.followIndexCreated;
    }

    public boolean followIndexShardsAcked() {
        return this.followIndexShardsAcked;
    }

    public boolean indexFollowingStarted() {
        return this.indexFollowingStarted;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("follow_index_created");
        generator.write(this.followIndexCreated);
        generator.writeKey("follow_index_shards_acked");
        generator.write(this.followIndexShardsAcked);
        generator.writeKey("index_following_started");
        generator.write(this.indexFollowingStarted);
    }

    protected static void setupFollowResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::followIndexCreated, JsonpDeserializer.booleanDeserializer(), "follow_index_created", new String[0]);
        op.add(Builder::followIndexShardsAcked, JsonpDeserializer.booleanDeserializer(), "follow_index_shards_acked", new String[0]);
        op.add(Builder::indexFollowingStarted, JsonpDeserializer.booleanDeserializer(), "index_following_started", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FollowResponse> {
        private Boolean followIndexCreated;
        private Boolean followIndexShardsAcked;
        private Boolean indexFollowingStarted;

        public Builder followIndexCreated(boolean value) {
            this.followIndexCreated = value;
            return this;
        }

        public Builder followIndexShardsAcked(boolean value) {
            this.followIndexShardsAcked = value;
            return this;
        }

        public Builder indexFollowingStarted(boolean value) {
            this.indexFollowingStarted = value;
            return this;
        }

        @Override
        public FollowResponse build() {
            return new FollowResponse(this);
        }
    }
}

