/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.async_search.StatusResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class StatusRequest
extends RequestBase {
    private final String id;
    private static final SimpleEndpoint<StatusRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_async_search");
            buf.append("/status");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, null);

    public StatusRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
    }

    public StatusRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public static <TDocument> Endpoint<StatusRequest, StatusResponse<TDocument>, ElasticsearchError> createStatusEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(StatusResponse.createStatusResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<StatusRequest> {
        private String id;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        @Override
        public StatusRequest build() {
            return new StatusRequest(this);
        }
    }
}

