/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SpanNotQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    @Nullable
    private final Integer dist;
    private final SpanQuery exclude;
    private final SpanQuery include;
    @Nullable
    private final Integer post;
    @Nullable
    private final Integer pre;
    public static final JsonpDeserializer<SpanNotQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanNotQuery::setupSpanNotQueryDeserializer, Builder::build);

    public SpanNotQuery(Builder builder) {
        super(builder);
        this.dist = builder.dist;
        this.exclude = Objects.requireNonNull(builder.exclude, "exclude");
        this.include = Objects.requireNonNull(builder.include, "include");
        this.post = builder.post;
        this.pre = builder.pre;
    }

    public SpanNotQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "span_not";
    }

    @Nullable
    public Integer dist() {
        return this.dist;
    }

    public SpanQuery exclude() {
        return this.exclude;
    }

    public SpanQuery include() {
        return this.include;
    }

    @Nullable
    public Integer post() {
        return this.post;
    }

    @Nullable
    public Integer pre() {
        return this.pre;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.dist != null) {
            generator.writeKey("dist");
            generator.write(this.dist.intValue());
        }
        generator.writeKey("exclude");
        this.exclude.serialize(generator, mapper);
        generator.writeKey("include");
        this.include.serialize(generator, mapper);
        if (this.post != null) {
            generator.writeKey("post");
            generator.write(this.post.intValue());
        }
        if (this.pre != null) {
            generator.writeKey("pre");
            generator.write(this.pre.intValue());
        }
    }

    protected static void setupSpanNotQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::dist, JsonpDeserializer.integerDeserializer(), "dist", new String[0]);
        op.add(Builder::exclude, SpanQuery._DESERIALIZER, "exclude", new String[0]);
        op.add(Builder::include, SpanQuery._DESERIALIZER, "include", new String[0]);
        op.add(Builder::post, JsonpDeserializer.integerDeserializer(), "post", new String[0]);
        op.add(Builder::pre, JsonpDeserializer.integerDeserializer(), "pre", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanNotQuery> {
        @Nullable
        private Integer dist;
        private SpanQuery exclude;
        private SpanQuery include;
        @Nullable
        private Integer post;
        @Nullable
        private Integer pre;

        public Builder dist(@Nullable Integer value) {
            this.dist = value;
            return this;
        }

        public Builder exclude(SpanQuery value) {
            this.exclude = value;
            return this;
        }

        public Builder exclude(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.exclude(fn.apply(new SpanQuery.Builder()).build());
        }

        public Builder include(SpanQuery value) {
            this.include = value;
            return this;
        }

        public Builder include(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.include(fn.apply(new SpanQuery.Builder()).build());
        }

        public Builder post(@Nullable Integer value) {
            this.post = value;
            return this;
        }

        public Builder pre(@Nullable Integer value) {
            this.pre = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanNotQuery build() {
            return new SpanNotQuery(this);
        }
    }
}

