/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.ScoreFunctionBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RandomScoreFunction
extends ScoreFunctionBase
implements FunctionScoreVariant {
    @Nullable
    private final String field;
    @Nullable
    private final String seed;
    public static final JsonpDeserializer<RandomScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RandomScoreFunction::setupRandomScoreFunctionDeserializer, Builder::build);

    public RandomScoreFunction(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.seed = builder.seed;
    }

    public RandomScoreFunction(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "random_score";
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public String seed() {
        return this.seed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.seed != null) {
            generator.writeKey("seed");
            generator.write(this.seed);
        }
    }

    protected static void setupRandomScoreFunctionDeserializer(DelegatingDeserializer<Builder> op) {
        ScoreFunctionBase.setupScoreFunctionBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::seed, JsonpDeserializer.stringDeserializer(), "seed", new String[0]);
    }

    public static class Builder
    extends ScoreFunctionBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RandomScoreFunction> {
        @Nullable
        private String field;
        @Nullable
        private String seed;

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder seed(@Nullable String value) {
            this.seed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RandomScoreFunction build() {
            return new RandomScoreFunction(this);
        }
    }
}

