/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PinnedQuery
extends QueryBase
implements QueryVariant {
    private final List<String> ids;
    private final Query organic;
    public static final JsonpDeserializer<PinnedQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PinnedQuery::setupPinnedQueryDeserializer, Builder::build);

    public PinnedQuery(Builder builder) {
        super(builder);
        this.ids = ModelTypeHelper.unmodifiableNonNull(builder.ids, "ids");
        this.organic = Objects.requireNonNull(builder.organic, "organic");
    }

    public PinnedQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "pinned";
    }

    public List<String> ids() {
        return this.ids;
    }

    public Query organic() {
        return this.organic;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("ids");
        generator.writeStartArray();
        for (String item0 : this.ids) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("organic");
        this.organic.serialize(generator, mapper);
    }

    protected static void setupPinnedQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids", new String[0]);
        op.add(Builder::organic, Query._DESERIALIZER, "organic", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PinnedQuery> {
        private List<String> ids;
        private Query organic;

        public Builder ids(List<String> value) {
            this.ids = value;
            return this;
        }

        public Builder ids(String ... value) {
            this.ids = Arrays.asList(value);
            return this;
        }

        public Builder addIds(String value) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            this.ids.add(value);
            return this;
        }

        public Builder organic(Query value) {
            this.organic = value;
            return this;
        }

        public Builder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.organic(fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PinnedQuery build() {
            return new PinnedQuery(this);
        }
    }
}

