/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.NestedScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NestedQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final InnerHits innerHits;
    private final String path;
    private final Query query;
    @Nullable
    private final NestedScoreMode scoreMode;
    public static final JsonpDeserializer<NestedQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedQuery::setupNestedQueryDeserializer, Builder::build);

    public NestedQuery(Builder builder) {
        super(builder);
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.innerHits = builder.innerHits;
        this.path = Objects.requireNonNull(builder.path, "path");
        this.query = Objects.requireNonNull(builder.query, "query");
        this.scoreMode = builder.scoreMode;
    }

    public NestedQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "nested";
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public InnerHits innerHits() {
        return this.innerHits;
    }

    public String path() {
        return this.path;
    }

    public Query query() {
        return this.query;
    }

    @Nullable
    public NestedScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    protected static void setupNestedQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::scoreMode, NestedScoreMode._DESERIALIZER, "score_mode", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NestedQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private InnerHits innerHits;
        private String path;
        private Query query;
        @Nullable
        private NestedScoreMode scoreMode;

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        public Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public Builder path(String value) {
            this.path = value;
            return this;
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder scoreMode(@Nullable NestedScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NestedQuery build() {
            return new NestedQuery(this);
        }
    }
}

