/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HasParentQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final InnerHits innerHits;
    private final String parentType;
    private final Query query;
    @Nullable
    private final Boolean score;
    public static final JsonpDeserializer<HasParentQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasParentQuery::setupHasParentQueryDeserializer, Builder::build);

    public HasParentQuery(Builder builder) {
        super(builder);
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.innerHits = builder.innerHits;
        this.parentType = Objects.requireNonNull(builder.parentType, "parent_type");
        this.query = Objects.requireNonNull(builder.query, "query");
        this.score = builder.score;
    }

    public HasParentQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "has_parent";
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public InnerHits innerHits() {
        return this.innerHits;
    }

    public String parentType() {
        return this.parentType;
    }

    public Query query() {
        return this.query;
    }

    @Nullable
    public Boolean score() {
        return this.score;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        generator.writeKey("parent_type");
        generator.write(this.parentType);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.score != null) {
            generator.writeKey("score");
            generator.write(this.score.booleanValue());
        }
    }

    protected static void setupHasParentQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits", new String[0]);
        op.add(Builder::parentType, JsonpDeserializer.stringDeserializer(), "parent_type", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::score, JsonpDeserializer.booleanDeserializer(), "score", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HasParentQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private InnerHits innerHits;
        private String parentType;
        private Query query;
        @Nullable
        private Boolean score;

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        public Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public Builder parentType(String value) {
            this.parentType = value;
            return this;
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder score(@Nullable Boolean value) {
            this.score = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HasParentQuery build() {
            return new HasParentQuery(this);
        }
    }
}

