/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class BoostingQuery
extends QueryBase
implements QueryVariant {
    private final double negativeBoost;
    private final Query negative;
    private final Query positive;
    public static final JsonpDeserializer<BoostingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoostingQuery::setupBoostingQueryDeserializer, Builder::build);

    public BoostingQuery(Builder builder) {
        super(builder);
        this.negativeBoost = Objects.requireNonNull(builder.negativeBoost, "negative_boost");
        this.negative = Objects.requireNonNull(builder.negative, "negative");
        this.positive = Objects.requireNonNull(builder.positive, "positive");
    }

    public BoostingQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "boosting";
    }

    public double negativeBoost() {
        return this.negativeBoost;
    }

    public Query negative() {
        return this.negative;
    }

    public Query positive() {
        return this.positive;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("negative_boost");
        generator.write(this.negativeBoost);
        generator.writeKey("negative");
        this.negative.serialize(generator, mapper);
        generator.writeKey("positive");
        this.positive.serialize(generator, mapper);
    }

    protected static void setupBoostingQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::negativeBoost, JsonpDeserializer.doubleDeserializer(), "negative_boost", new String[0]);
        op.add(Builder::negative, Query._DESERIALIZER, "negative", new String[0]);
        op.add(Builder::positive, Query._DESERIALIZER, "positive", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoostingQuery> {
        private Double negativeBoost;
        private Query negative;
        private Query positive;

        public Builder negativeBoost(double value) {
            this.negativeBoost = value;
            return this;
        }

        public Builder negative(Query value) {
            this.negative = value;
            return this;
        }

        public Builder negative(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.negative(fn.apply(new Query.Builder()).build());
        }

        public Builder positive(Query value) {
            this.positive = value;
            return this;
        }

        public Builder positive(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.positive(fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoostingQuery build() {
            return new BoostingQuery(this);
        }
    }
}

