/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SourceField
implements JsonpSerializable {
    @Nullable
    private final Boolean compress;
    @Nullable
    private final String compressThreshold;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final List<String> excludes;
    @Nullable
    private final List<String> includes;
    public static final JsonpDeserializer<SourceField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceField::setupSourceFieldDeserializer, Builder::build);

    public SourceField(Builder builder) {
        this.compress = builder.compress;
        this.compressThreshold = builder.compressThreshold;
        this.enabled = builder.enabled;
        this.excludes = ModelTypeHelper.unmodifiable(builder.excludes);
        this.includes = ModelTypeHelper.unmodifiable(builder.includes);
    }

    public SourceField(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean compress() {
        return this.compress;
    }

    @Nullable
    public String compressThreshold() {
        return this.compressThreshold;
    }

    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public List<String> excludes() {
        return this.excludes;
    }

    @Nullable
    public List<String> includes() {
        return this.includes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compress != null) {
            generator.writeKey("compress");
            generator.write(this.compress.booleanValue());
        }
        if (this.compressThreshold != null) {
            generator.writeKey("compress_threshold");
            generator.write(this.compressThreshold);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.excludes != null) {
            generator.writeKey("excludes");
            generator.writeStartArray();
            for (String item0 : this.excludes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.includes != null) {
            generator.writeKey("includes");
            generator.writeStartArray();
            for (String item0 : this.includes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSourceFieldDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::compress, JsonpDeserializer.booleanDeserializer(), "compress", new String[0]);
        op.add(Builder::compressThreshold, JsonpDeserializer.stringDeserializer(), "compress_threshold", new String[0]);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
        op.add(Builder::excludes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "excludes", new String[0]);
        op.add(Builder::includes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "includes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SourceField> {
        @Nullable
        private Boolean compress;
        @Nullable
        private String compressThreshold;
        @Nullable
        private Boolean enabled;
        @Nullable
        private List<String> excludes;
        @Nullable
        private List<String> includes;

        public Builder compress(@Nullable Boolean value) {
            this.compress = value;
            return this;
        }

        public Builder compressThreshold(@Nullable String value) {
            this.compressThreshold = value;
            return this;
        }

        public Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder excludes(@Nullable List<String> value) {
            this.excludes = value;
            return this;
        }

        public Builder excludes(String ... value) {
            this.excludes = Arrays.asList(value);
            return this;
        }

        public Builder addExcludes(String value) {
            if (this.excludes == null) {
                this.excludes = new ArrayList<String>();
            }
            this.excludes.add(value);
            return this;
        }

        public Builder includes(@Nullable List<String> value) {
            this.includes = value;
            return this;
        }

        public Builder includes(String ... value) {
            this.includes = Arrays.asList(value);
            return this;
        }

        public Builder addIncludes(String value) {
            if (this.includes == null) {
                this.includes = new ArrayList<String>();
            }
            this.includes.add(value);
            return this;
        }

        @Override
        public SourceField build() {
            return new SourceField(this);
        }
    }
}

