/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.RuntimeFieldType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RuntimeField
implements JsonpSerializable {
    @Nullable
    private final String format;
    @Nullable
    private final JsonValue script;
    private final RuntimeFieldType type;
    public static final JsonpDeserializer<RuntimeField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeField::setupRuntimeFieldDeserializer, Builder::build);

    public RuntimeField(Builder builder) {
        this.format = builder.format;
        this.script = builder.script;
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public RuntimeField(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    public RuntimeFieldType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    protected static void setupRuntimeFieldDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::type, RuntimeFieldType._DESERIALIZER, "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RuntimeField> {
        @Nullable
        private String format;
        @Nullable
        private JsonValue script;
        private RuntimeFieldType type;

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder type(RuntimeFieldType value) {
            this.type = value;
            return this;
        }

        @Override
        public RuntimeField build() {
            return new RuntimeField(this);
        }
    }
}

