/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class RangePropertyBase
extends DocValuesPropertyBase {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Boolean index;

    public RangePropertyBase(AbstractBuilder<?> builder) {
        super((DocValuesPropertyBase.AbstractBuilder<?>)builder);
        this.boost = ((AbstractBuilder)builder).boost;
        this.coerce = ((AbstractBuilder)builder).coerce;
        this.index = ((AbstractBuilder)builder).index;
    }

    @Nullable
    public Double boost() {
        return this.boost;
    }

    @Nullable
    public Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupRangePropertyBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(AbstractBuilder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce", new String[0]);
        op.add(AbstractBuilder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends DocValuesPropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean coerce;
        @Nullable
        private Boolean index;

        protected AbstractBuilder() {
        }

        public BuilderT boost(@Nullable Double value) {
            this.boost = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT coerce(@Nullable Boolean value) {
            this.coerce = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT index(@Nullable Boolean value) {
            this.index = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

