/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class JoinProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Map<String, List<String>> relations;
    public static final JsonpDeserializer<JoinProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JoinProperty::setupJoinPropertyDeserializer, Builder::build);

    public JoinProperty(Builder builder) {
        super(builder);
        this.relations = ModelTypeHelper.unmodifiable(builder.relations);
    }

    public JoinProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "join";
    }

    @Nullable
    public Map<String, List<String>> relations() {
        return this.relations;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "join");
        super.serializeInternal(generator, mapper);
        if (this.relations != null) {
            generator.writeKey("relations");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.relations.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                for (String item1 : item0.getValue()) {
                    generator.write(item1);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupJoinPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::relations, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "relations", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<JoinProperty> {
        @Nullable
        private Map<String, List<String>> relations;

        public Builder relations(@Nullable Map<String, List<String>> value) {
            this.relations = value;
            return this;
        }

        public Builder putRelations(String key, List<String> value) {
            if (this.relations == null) {
                this.relations = new HashMap<String, List<String>>();
            }
            this.relations.put(key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JoinProperty build() {
            return new JoinProperty(this);
        }
    }
}

