/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.ModelTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CorePropertyBase
extends PropertyBase {
    @Nullable
    private final List<String> copyTo;
    @Nullable
    private final String similarity;
    @Nullable
    private final Boolean store;

    public CorePropertyBase(AbstractBuilder<?> builder) {
        super(builder);
        this.copyTo = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).copyTo);
        this.similarity = ((AbstractBuilder)builder).similarity;
        this.store = ((AbstractBuilder)builder).store;
    }

    @Nullable
    public List<String> copyTo() {
        return this.copyTo;
    }

    @Nullable
    public String similarity() {
        return this.similarity;
    }

    @Nullable
    public Boolean store() {
        return this.store;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.copyTo != null) {
            generator.writeKey("copy_to");
            generator.writeStartArray();
            for (String item0 : this.copyTo) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write(this.similarity);
        }
        if (this.store != null) {
            generator.writeKey("store");
            generator.write(this.store.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCorePropertyBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::copyTo, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "copy_to", new String[0]);
        op.add(AbstractBuilder::similarity, JsonpDeserializer.stringDeserializer(), "similarity", new String[0]);
        op.add(AbstractBuilder::store, JsonpDeserializer.booleanDeserializer(), "store", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends PropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private List<String> copyTo;
        @Nullable
        private String similarity;
        @Nullable
        private Boolean store;

        protected AbstractBuilder() {
        }

        public BuilderT copyTo(@Nullable List<String> value) {
            this.copyTo = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT copyTo(String ... value) {
            this.copyTo = Arrays.asList(value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT addCopyTo(String value) {
            if (this.copyTo == null) {
                this.copyTo = new ArrayList<String>();
            }
            this.copyTo.add(value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT similarity(@Nullable String value) {
            this.similarity = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT store(@Nullable Boolean value) {
            this.store = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

