/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StopTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    @Nullable
    private final Boolean ignoreCase;
    @Nullable
    private final Boolean removeTrailing;
    private final List<String> stopwords;
    @Nullable
    private final String stopwordsPath;
    public static final JsonpDeserializer<StopTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StopTokenFilter::setupStopTokenFilterDeserializer, Builder::build);

    public StopTokenFilter(Builder builder) {
        super(builder);
        this.ignoreCase = builder.ignoreCase;
        this.removeTrailing = builder.removeTrailing;
        this.stopwords = ModelTypeHelper.unmodifiableNonNull(builder.stopwords, "stopwords");
        this.stopwordsPath = builder.stopwordsPath;
    }

    public StopTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "stop";
    }

    @Nullable
    public Boolean ignoreCase() {
        return this.ignoreCase;
    }

    @Nullable
    public Boolean removeTrailing() {
        return this.removeTrailing;
    }

    public List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "stop");
        super.serializeInternal(generator, mapper);
        if (this.ignoreCase != null) {
            generator.writeKey("ignore_case");
            generator.write(this.ignoreCase.booleanValue());
        }
        if (this.removeTrailing != null) {
            generator.writeKey("remove_trailing");
            generator.write(this.removeTrailing.booleanValue());
        }
        generator.writeKey("stopwords");
        generator.writeStartArray();
        for (String item0 : this.stopwords) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.stopwordsPath != null) {
            generator.writeKey("stopwords_path");
            generator.write(this.stopwordsPath);
        }
    }

    protected static void setupStopTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case", new String[0]);
        op.add(Builder::removeTrailing, JsonpDeserializer.booleanDeserializer(), "remove_trailing", new String[0]);
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords", new String[0]);
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StopTokenFilter> {
        @Nullable
        private Boolean ignoreCase;
        @Nullable
        private Boolean removeTrailing;
        private List<String> stopwords;
        @Nullable
        private String stopwordsPath;

        public Builder ignoreCase(@Nullable Boolean value) {
            this.ignoreCase = value;
            return this;
        }

        public Builder removeTrailing(@Nullable Boolean value) {
            this.removeTrailing = value;
            return this;
        }

        public Builder stopwords(List<String> value) {
            this.stopwords = value;
            return this;
        }

        public Builder stopwords(String ... value) {
            this.stopwords = Arrays.asList(value);
            return this;
        }

        public Builder addStopwords(String value) {
            if (this.stopwords == null) {
                this.stopwords = new ArrayList<String>();
            }
            this.stopwords.add(value);
            return this;
        }

        public Builder stopwordsPath(@Nullable String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StopTokenFilter build() {
            return new StopTokenFilter(this);
        }
    }
}

