/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PredicateTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final JsonValue script;
    public static final JsonpDeserializer<PredicateTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PredicateTokenFilter::setupPredicateTokenFilterDeserializer, Builder::build);

    public PredicateTokenFilter(Builder builder) {
        super(builder);
        this.script = Objects.requireNonNull(builder.script, "script");
    }

    public PredicateTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "predicate_token_filter";
    }

    public JsonValue script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "predicate_token_filter");
        super.serializeInternal(generator, mapper);
        generator.writeKey("script");
        generator.write(this.script);
    }

    protected static void setupPredicateTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PredicateTokenFilter> {
        private JsonValue script;

        public Builder script(JsonValue value) {
            this.script = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PredicateTokenFilter build() {
            return new PredicateTokenFilter(this);
        }
    }
}

