/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KeepWordsTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> keepWords;
    private final boolean keepWordsCase;
    private final String keepWordsPath;
    public static final JsonpDeserializer<KeepWordsTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeepWordsTokenFilter::setupKeepWordsTokenFilterDeserializer, Builder::build);

    public KeepWordsTokenFilter(Builder builder) {
        super(builder);
        this.keepWords = ModelTypeHelper.unmodifiableNonNull(builder.keepWords, "keep_words");
        this.keepWordsCase = Objects.requireNonNull(builder.keepWordsCase, "keep_words_case");
        this.keepWordsPath = Objects.requireNonNull(builder.keepWordsPath, "keep_words_path");
    }

    public KeepWordsTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "keep";
    }

    public List<String> keepWords() {
        return this.keepWords;
    }

    public boolean keepWordsCase() {
        return this.keepWordsCase;
    }

    public String keepWordsPath() {
        return this.keepWordsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keep");
        super.serializeInternal(generator, mapper);
        generator.writeKey("keep_words");
        generator.writeStartArray();
        for (String item0 : this.keepWords) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("keep_words_case");
        generator.write(this.keepWordsCase);
        generator.writeKey("keep_words_path");
        generator.write(this.keepWordsPath);
    }

    protected static void setupKeepWordsTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::keepWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "keep_words", new String[0]);
        op.add(Builder::keepWordsCase, JsonpDeserializer.booleanDeserializer(), "keep_words_case", new String[0]);
        op.add(Builder::keepWordsPath, JsonpDeserializer.stringDeserializer(), "keep_words_path", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeepWordsTokenFilter> {
        private List<String> keepWords;
        private Boolean keepWordsCase;
        private String keepWordsPath;

        public Builder keepWords(List<String> value) {
            this.keepWords = value;
            return this;
        }

        public Builder keepWords(String ... value) {
            this.keepWords = Arrays.asList(value);
            return this;
        }

        public Builder addKeepWords(String value) {
            if (this.keepWords == null) {
                this.keepWords = new ArrayList<String>();
            }
            this.keepWords.add(value);
            return this;
        }

        public Builder keepWordsCase(boolean value) {
            this.keepWordsCase = value;
            return this;
        }

        public Builder keepWordsPath(String value) {
            this.keepWordsPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeepWordsTokenFilter build() {
            return new KeepWordsTokenFilter(this);
        }
    }
}

