/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class HunspellTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean dedup;
    private final String dictionary;
    private final String locale;
    private final boolean longestOnly;
    public static final JsonpDeserializer<HunspellTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HunspellTokenFilter::setupHunspellTokenFilterDeserializer, Builder::build);

    public HunspellTokenFilter(Builder builder) {
        super(builder);
        this.dedup = Objects.requireNonNull(builder.dedup, "dedup");
        this.dictionary = Objects.requireNonNull(builder.dictionary, "dictionary");
        this.locale = Objects.requireNonNull(builder.locale, "locale");
        this.longestOnly = Objects.requireNonNull(builder.longestOnly, "longest_only");
    }

    public HunspellTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "hunspell";
    }

    public boolean dedup() {
        return this.dedup;
    }

    public String dictionary() {
        return this.dictionary;
    }

    public String locale() {
        return this.locale;
    }

    public boolean longestOnly() {
        return this.longestOnly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "hunspell");
        super.serializeInternal(generator, mapper);
        generator.writeKey("dedup");
        generator.write(this.dedup);
        generator.writeKey("dictionary");
        generator.write(this.dictionary);
        generator.writeKey("locale");
        generator.write(this.locale);
        generator.writeKey("longest_only");
        generator.write(this.longestOnly);
    }

    protected static void setupHunspellTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::dedup, JsonpDeserializer.booleanDeserializer(), "dedup", new String[0]);
        op.add(Builder::dictionary, JsonpDeserializer.stringDeserializer(), "dictionary", new String[0]);
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale", new String[0]);
        op.add(Builder::longestOnly, JsonpDeserializer.booleanDeserializer(), "longest_only", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HunspellTokenFilter> {
        private Boolean dedup;
        private String dictionary;
        private String locale;
        private Boolean longestOnly;

        public Builder dedup(boolean value) {
            this.dedup = value;
            return this;
        }

        public Builder dictionary(String value) {
            this.dictionary = value;
            return this;
        }

        public Builder locale(String value) {
            this.locale = value;
            return this;
        }

        public Builder longestOnly(boolean value) {
            this.longestOnly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HunspellTokenFilter build() {
            return new HunspellTokenFilter(this);
        }
    }
}

