/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FingerprintTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final int maxOutputSize;
    private final String separator;
    public static final JsonpDeserializer<FingerprintTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintTokenFilter::setupFingerprintTokenFilterDeserializer, Builder::build);

    public FingerprintTokenFilter(Builder builder) {
        super(builder);
        this.maxOutputSize = Objects.requireNonNull(builder.maxOutputSize, "max_output_size");
        this.separator = Objects.requireNonNull(builder.separator, "separator");
    }

    public FingerprintTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "fingerprint";
    }

    public int maxOutputSize() {
        return this.maxOutputSize;
    }

    public String separator() {
        return this.separator;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fingerprint");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max_output_size");
        generator.write(this.maxOutputSize);
        generator.writeKey("separator");
        generator.write(this.separator);
    }

    protected static void setupFingerprintTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxOutputSize, JsonpDeserializer.integerDeserializer(), "max_output_size", new String[0]);
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FingerprintTokenFilter> {
        private Integer maxOutputSize;
        private String separator;

        public Builder maxOutputSize(int value) {
            this.maxOutputSize = value;
            return this;
        }

        public Builder separator(String value) {
            this.separator = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FingerprintTokenFilter build() {
            return new FingerprintTokenFilter(this);
        }
    }
}

