/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CommonGramsTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> commonWords;
    private final String commonWordsPath;
    private final boolean ignoreCase;
    private final boolean queryMode;
    public static final JsonpDeserializer<CommonGramsTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CommonGramsTokenFilter::setupCommonGramsTokenFilterDeserializer, Builder::build);

    public CommonGramsTokenFilter(Builder builder) {
        super(builder);
        this.commonWords = ModelTypeHelper.unmodifiableNonNull(builder.commonWords, "common_words");
        this.commonWordsPath = Objects.requireNonNull(builder.commonWordsPath, "common_words_path");
        this.ignoreCase = Objects.requireNonNull(builder.ignoreCase, "ignore_case");
        this.queryMode = Objects.requireNonNull(builder.queryMode, "query_mode");
    }

    public CommonGramsTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "common_grams";
    }

    public List<String> commonWords() {
        return this.commonWords;
    }

    public String commonWordsPath() {
        return this.commonWordsPath;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public boolean queryMode() {
        return this.queryMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "common_grams");
        super.serializeInternal(generator, mapper);
        generator.writeKey("common_words");
        generator.writeStartArray();
        for (String item0 : this.commonWords) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("common_words_path");
        generator.write(this.commonWordsPath);
        generator.writeKey("ignore_case");
        generator.write(this.ignoreCase);
        generator.writeKey("query_mode");
        generator.write(this.queryMode);
    }

    protected static void setupCommonGramsTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::commonWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "common_words", new String[0]);
        op.add(Builder::commonWordsPath, JsonpDeserializer.stringDeserializer(), "common_words_path", new String[0]);
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case", new String[0]);
        op.add(Builder::queryMode, JsonpDeserializer.booleanDeserializer(), "query_mode", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CommonGramsTokenFilter> {
        private List<String> commonWords;
        private String commonWordsPath;
        private Boolean ignoreCase;
        private Boolean queryMode;

        public Builder commonWords(List<String> value) {
            this.commonWords = value;
            return this;
        }

        public Builder commonWords(String ... value) {
            this.commonWords = Arrays.asList(value);
            return this;
        }

        public Builder addCommonWords(String value) {
            if (this.commonWords == null) {
                this.commonWords = new ArrayList<String>();
            }
            this.commonWords.add(value);
            return this;
        }

        public Builder commonWordsPath(String value) {
            this.commonWordsPath = value;
            return this;
        }

        public Builder ignoreCase(boolean value) {
            this.ignoreCase = value;
            return this;
        }

        public Builder queryMode(boolean value) {
            this.queryMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CommonGramsTokenFilter build() {
            return new CommonGramsTokenFilter(this);
        }
    }
}

