/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch.core.search.SortOrder;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HistogramOrder
implements JsonpSerializable {
    @Nullable
    private final SortOrder count;
    @Nullable
    private final SortOrder key;
    public static final JsonpDeserializer<HistogramOrder> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramOrder::setupHistogramOrderDeserializer, Builder::build);

    public HistogramOrder(Builder builder) {
        this.count = builder.count;
        this.key = builder.key;
    }

    public HistogramOrder(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public SortOrder count() {
        return this.count;
    }

    @Nullable
    public SortOrder key() {
        return this.key;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("_count");
            this.count.serialize(generator, mapper);
        }
        if (this.key != null) {
            generator.writeKey("_key");
            this.key.serialize(generator, mapper);
        }
    }

    protected static void setupHistogramOrderDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, SortOrder._DESERIALIZER, "_count", new String[0]);
        op.add(Builder::key, SortOrder._DESERIALIZER, "_key", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HistogramOrder> {
        @Nullable
        private SortOrder count;
        @Nullable
        private SortOrder key;

        public Builder count(@Nullable SortOrder value) {
            this.count = value;
            return this;
        }

        public Builder key(@Nullable SortOrder value) {
            this.key = value;
            return this;
        }

        @Override
        public HistogramOrder build() {
            return new HistogramOrder(this);
        }
    }
}

