/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ChainTransform;
import co.elastic.clients.elasticsearch._types.ScriptTransform;
import co.elastic.clients.elasticsearch._types.SearchTransform;
import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Transform
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String CHAIN = "chain";
    public static final String SCRIPT = "script";
    public static final String SEARCH = "search";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Transform> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Transform::setupTransformDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Transform(TransformVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends TransformVariant> Transform(ObjectBuilder<T> builder) {
        this((TransformVariant)builder.build());
    }

    private Transform(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Transform(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ChainTransform chain() {
        return (ChainTransform)TaggedUnionUtils.get(this, CHAIN);
    }

    public ScriptTransform script() {
        return (ScriptTransform)TaggedUnionUtils.get(this, SCRIPT);
    }

    public SearchTransform search() {
        return (SearchTransform)TaggedUnionUtils.get(this, SEARCH);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTransformDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::chain, ChainTransform._DESERIALIZER, CHAIN, new String[0]);
        op.add(Builder::script, ScriptTransform._DESERIALIZER, SCRIPT, new String[0]);
        op.add(Builder::search, SearchTransform._DESERIALIZER, SEARCH, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Transform> {
        private String _type;
        private Object _value;

        public Builder chain(ChainTransform v) {
            this._type = Transform.CHAIN;
            this._value = v;
            return this;
        }

        public Builder chain(Function<ChainTransform.Builder, ObjectBuilder<ChainTransform>> f) {
            return this.chain(f.apply(new ChainTransform.Builder()).build());
        }

        public Builder script(ScriptTransform v) {
            this._type = Transform.SCRIPT;
            this._value = v;
            return this;
        }

        public Builder script(Function<ScriptTransform.Builder, ObjectBuilder<ScriptTransform>> f) {
            return this.script(f.apply(new ScriptTransform.Builder()).build());
        }

        public Builder search(SearchTransform v) {
            this._type = Transform.SEARCH;
            this._value = v;
            return this;
        }

        public Builder search(Function<SearchTransform.Builder, ObjectBuilder<SearchTransform>> f) {
            return this.search(f.apply(new SearchTransform.Builder()).build());
        }

        @Override
        public Transform build() {
            return new Transform(this);
        }
    }
}

