/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShardFailure
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String node;
    private final ErrorCause reason;
    private final int shard;
    @Nullable
    private final String status;
    public static final JsonpDeserializer<ShardFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardFailure::setupShardFailureDeserializer, Builder::build);

    public ShardFailure(Builder builder) {
        this.index = builder.index;
        this.node = builder.node;
        this.reason = Objects.requireNonNull(builder.reason, "reason");
        this.shard = Objects.requireNonNull(builder.shard, "shard");
        this.status = builder.status;
    }

    public ShardFailure(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String node() {
        return this.node;
    }

    public ErrorCause reason() {
        return this.reason;
    }

    public int shard() {
        return this.shard;
    }

    @Nullable
    public String status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
    }

    protected static void setupShardFailureDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::reason, ErrorCause._DESERIALIZER, "reason", new String[0]);
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard", new String[0]);
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardFailure> {
        @Nullable
        private String index;
        @Nullable
        private String node;
        private ErrorCause reason;
        private Integer shard;
        @Nullable
        private String status;

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public Builder reason(ErrorCause value) {
            this.reason = value;
            return this;
        }

        public Builder reason(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.reason(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public Builder status(@Nullable String value) {
            this.status = value;
            return this;
        }

        @Override
        public ShardFailure build() {
            return new ShardFailure(this);
        }
    }
}

