/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Retries
implements JsonpSerializable {
    private final long bulk;
    private final long search;
    public static final JsonpDeserializer<Retries> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Retries::setupRetriesDeserializer, Builder::build);

    public Retries(Builder builder) {
        this.bulk = Objects.requireNonNull(builder.bulk, "bulk");
        this.search = Objects.requireNonNull(builder.search, "search");
    }

    public Retries(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long bulk() {
        return this.bulk;
    }

    public long search() {
        return this.search;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bulk");
        generator.write(this.bulk);
        generator.writeKey("search");
        generator.write(this.search);
    }

    protected static void setupRetriesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bulk, JsonpDeserializer.longDeserializer(), "bulk", new String[0]);
        op.add(Builder::search, JsonpDeserializer.longDeserializer(), "search", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Retries> {
        private Long bulk;
        private Long search;

        public Builder bulk(long value) {
            this.bulk = value;
            return this;
        }

        public Builder search(long value) {
            this.search = value;
            return this;
        }

        @Override
        public Retries build() {
            return new Retries(this);
        }
    }
}

