/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class QueryCacheStats
implements JsonpSerializable {
    private final int cacheCount;
    private final int cacheSize;
    private final int evictions;
    private final int hitCount;
    @Nullable
    private final String memorySize;
    private final int memorySizeInBytes;
    private final int missCount;
    private final int totalCount;
    public static final JsonpDeserializer<QueryCacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryCacheStats::setupQueryCacheStatsDeserializer, Builder::build);

    public QueryCacheStats(Builder builder) {
        this.cacheCount = Objects.requireNonNull(builder.cacheCount, "cache_count");
        this.cacheSize = Objects.requireNonNull(builder.cacheSize, "cache_size");
        this.evictions = Objects.requireNonNull(builder.evictions, "evictions");
        this.hitCount = Objects.requireNonNull(builder.hitCount, "hit_count");
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = Objects.requireNonNull(builder.memorySizeInBytes, "memory_size_in_bytes");
        this.missCount = Objects.requireNonNull(builder.missCount, "miss_count");
        this.totalCount = Objects.requireNonNull(builder.totalCount, "total_count");
    }

    public QueryCacheStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int cacheCount() {
        return this.cacheCount;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public int evictions() {
        return this.evictions;
    }

    public int hitCount() {
        return this.hitCount;
    }

    @Nullable
    public String memorySize() {
        return this.memorySize;
    }

    public int memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public int missCount() {
        return this.missCount;
    }

    public int totalCount() {
        return this.totalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_count");
        generator.write(this.cacheCount);
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
        generator.writeKey("total_count");
        generator.write(this.totalCount);
    }

    protected static void setupQueryCacheStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cacheCount, JsonpDeserializer.integerDeserializer(), "cache_count", new String[0]);
        op.add(Builder::cacheSize, JsonpDeserializer.integerDeserializer(), "cache_size", new String[0]);
        op.add(Builder::evictions, JsonpDeserializer.integerDeserializer(), "evictions", new String[0]);
        op.add(Builder::hitCount, JsonpDeserializer.integerDeserializer(), "hit_count", new String[0]);
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size", new String[0]);
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.integerDeserializer(), "memory_size_in_bytes", new String[0]);
        op.add(Builder::missCount, JsonpDeserializer.integerDeserializer(), "miss_count", new String[0]);
        op.add(Builder::totalCount, JsonpDeserializer.integerDeserializer(), "total_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<QueryCacheStats> {
        private Integer cacheCount;
        private Integer cacheSize;
        private Integer evictions;
        private Integer hitCount;
        @Nullable
        private String memorySize;
        private Integer memorySizeInBytes;
        private Integer missCount;
        private Integer totalCount;

        public Builder cacheCount(int value) {
            this.cacheCount = value;
            return this;
        }

        public Builder cacheSize(int value) {
            this.cacheSize = value;
            return this;
        }

        public Builder evictions(int value) {
            this.evictions = value;
            return this;
        }

        public Builder hitCount(int value) {
            this.hitCount = value;
            return this;
        }

        public Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public Builder memorySizeInBytes(int value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public Builder missCount(int value) {
            this.missCount = value;
            return this;
        }

        public Builder totalCount(int value) {
            this.totalCount = value;
            return this;
        }

        @Override
        public QueryCacheStats build() {
            return new QueryCacheStats(this);
        }
    }
}

