/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.elasticsearch.core.scripts_painless_execute.PainlessExecutionPosition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ErrorCause
implements JsonpSerializable {
    private final String type;
    private final String reason;
    @Nullable
    private final ErrorCause causedBy;
    @Nullable
    private final String shard;
    @Nullable
    private final String stackTrace;
    @Nullable
    private final List<ErrorCause> rootCause;
    @Nullable
    private final Long bytesLimit;
    @Nullable
    private final Long bytesWanted;
    @Nullable
    private final Integer column;
    @Nullable
    private final Integer col;
    @Nullable
    private final List<ShardFailure> failedShards;
    @Nullable
    private final Boolean grouped;
    @Nullable
    private final String index;
    @Nullable
    private final String indexUuid;
    @Nullable
    private final String language;
    @Nullable
    private final String licensedExpiredFeature;
    @Nullable
    private final Integer line;
    @Nullable
    private final Integer maxBuckets;
    @Nullable
    private final String phase;
    @Nullable
    private final String propertyName;
    @Nullable
    private final String processorType;
    @Nullable
    private final List<String> resourceId;
    @Nullable
    private final String resourceType;
    @Nullable
    private final String script;
    @Nullable
    private final List<String> scriptStack;
    @Nullable
    private final Map<String, List<String>> header;
    @Nullable
    private final String lang;
    @Nullable
    private final PainlessExecutionPosition position;
    public static final JsonpDeserializer<ErrorCause> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ErrorCause::setupErrorCauseDeserializer, Builder::build);

    public ErrorCause(AbstractBuilder<?> builder) {
        this.type = Objects.requireNonNull(((AbstractBuilder)builder).type, "type");
        this.reason = Objects.requireNonNull(((AbstractBuilder)builder).reason, "reason");
        this.causedBy = ((AbstractBuilder)builder).causedBy;
        this.shard = ((AbstractBuilder)builder).shard;
        this.stackTrace = ((AbstractBuilder)builder).stackTrace;
        this.rootCause = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).rootCause);
        this.bytesLimit = ((AbstractBuilder)builder).bytesLimit;
        this.bytesWanted = ((AbstractBuilder)builder).bytesWanted;
        this.column = ((AbstractBuilder)builder).column;
        this.col = ((AbstractBuilder)builder).col;
        this.failedShards = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).failedShards);
        this.grouped = ((AbstractBuilder)builder).grouped;
        this.index = ((AbstractBuilder)builder).index;
        this.indexUuid = ((AbstractBuilder)builder).indexUuid;
        this.language = ((AbstractBuilder)builder).language;
        this.licensedExpiredFeature = ((AbstractBuilder)builder).licensedExpiredFeature;
        this.line = ((AbstractBuilder)builder).line;
        this.maxBuckets = ((AbstractBuilder)builder).maxBuckets;
        this.phase = ((AbstractBuilder)builder).phase;
        this.propertyName = ((AbstractBuilder)builder).propertyName;
        this.processorType = ((AbstractBuilder)builder).processorType;
        this.resourceId = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).resourceId);
        this.resourceType = ((AbstractBuilder)builder).resourceType;
        this.script = ((AbstractBuilder)builder).script;
        this.scriptStack = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).scriptStack);
        this.header = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).header);
        this.lang = ((AbstractBuilder)builder).lang;
        this.position = ((AbstractBuilder)builder).position;
    }

    public String type() {
        return this.type;
    }

    public String reason() {
        return this.reason;
    }

    @Nullable
    public ErrorCause causedBy() {
        return this.causedBy;
    }

    @Nullable
    public String shard() {
        return this.shard;
    }

    @Nullable
    public String stackTrace() {
        return this.stackTrace;
    }

    @Nullable
    public List<ErrorCause> rootCause() {
        return this.rootCause;
    }

    @Nullable
    public Long bytesLimit() {
        return this.bytesLimit;
    }

    @Nullable
    public Long bytesWanted() {
        return this.bytesWanted;
    }

    @Nullable
    public Integer column() {
        return this.column;
    }

    @Nullable
    public Integer col() {
        return this.col;
    }

    @Nullable
    public List<ShardFailure> failedShards() {
        return this.failedShards;
    }

    @Nullable
    public Boolean grouped() {
        return this.grouped;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String indexUuid() {
        return this.indexUuid;
    }

    @Nullable
    public String language() {
        return this.language;
    }

    @Nullable
    public String licensedExpiredFeature() {
        return this.licensedExpiredFeature;
    }

    @Nullable
    public Integer line() {
        return this.line;
    }

    @Nullable
    public Integer maxBuckets() {
        return this.maxBuckets;
    }

    @Nullable
    public String phase() {
        return this.phase;
    }

    @Nullable
    public String propertyName() {
        return this.propertyName;
    }

    @Nullable
    public String processorType() {
        return this.processorType;
    }

    @Nullable
    public List<String> resourceId() {
        return this.resourceId;
    }

    @Nullable
    public String resourceType() {
        return this.resourceType;
    }

    @Nullable
    public String script() {
        return this.script;
    }

    @Nullable
    public List<String> scriptStack() {
        return this.scriptStack;
    }

    @Nullable
    public Map<String, List<String>> header() {
        return this.header;
    }

    @Nullable
    public String lang() {
        return this.lang;
    }

    @Nullable
    public PainlessExecutionPosition position() {
        return this.position;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("reason");
        generator.write(this.reason);
        if (this.causedBy != null) {
            generator.writeKey("caused_by");
            this.causedBy.serialize(generator, mapper);
        }
        if (this.shard != null) {
            generator.writeKey("shard");
            generator.write(this.shard);
        }
        if (this.stackTrace != null) {
            generator.writeKey("stack_trace");
            generator.write(this.stackTrace);
        }
        if (this.rootCause != null) {
            generator.writeKey("root_cause");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.rootCause) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.bytesLimit != null) {
            generator.writeKey("bytes_limit");
            generator.write(this.bytesLimit.longValue());
        }
        if (this.bytesWanted != null) {
            generator.writeKey("bytes_wanted");
            generator.write(this.bytesWanted.longValue());
        }
        if (this.column != null) {
            generator.writeKey("column");
            generator.write(this.column.intValue());
        }
        if (this.col != null) {
            generator.writeKey("col");
            generator.write(this.col.intValue());
        }
        if (this.failedShards != null) {
            generator.writeKey("failed_shards");
            generator.writeStartArray();
            for (ShardFailure shardFailure : this.failedShards) {
                shardFailure.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.grouped != null) {
            generator.writeKey("grouped");
            generator.write(this.grouped.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.indexUuid != null) {
            generator.writeKey("index_uuid");
            generator.write(this.indexUuid);
        }
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
        if (this.licensedExpiredFeature != null) {
            generator.writeKey("licensed_expired_feature");
            generator.write(this.licensedExpiredFeature);
        }
        if (this.line != null) {
            generator.writeKey("line");
            generator.write(this.line.intValue());
        }
        if (this.maxBuckets != null) {
            generator.writeKey("max_buckets");
            generator.write(this.maxBuckets.intValue());
        }
        if (this.phase != null) {
            generator.writeKey("phase");
            generator.write(this.phase);
        }
        if (this.propertyName != null) {
            generator.writeKey("property_name");
            generator.write(this.propertyName);
        }
        if (this.processorType != null) {
            generator.writeKey("processor_type");
            generator.write(this.processorType);
        }
        if (this.resourceId != null) {
            generator.writeKey("resource_id");
            generator.writeStartArray();
            for (String string : this.resourceId) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.resourceType != null) {
            generator.writeKey("resource_type");
            generator.write(this.resourceType);
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.scriptStack != null) {
            generator.writeKey("script_stack");
            generator.writeStartArray();
            for (String string : this.scriptStack) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.header != null) {
            generator.writeKey("header");
            generator.writeStartObject();
            for (Map.Entry entry : this.header.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                for (String item1 : (List)entry.getValue()) {
                    generator.write(item1);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.lang != null) {
            generator.writeKey("lang");
            generator.write(this.lang);
        }
        if (this.position != null) {
            generator.writeKey("position");
            this.position.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupErrorCauseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(AbstractBuilder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
        op.add(AbstractBuilder::causedBy, _DESERIALIZER, "caused_by", new String[0]);
        op.add(AbstractBuilder::shard, JsonpDeserializer.stringDeserializer(), "shard", new String[0]);
        op.add(AbstractBuilder::stackTrace, JsonpDeserializer.stringDeserializer(), "stack_trace", new String[0]);
        op.add(AbstractBuilder::rootCause, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "root_cause", new String[0]);
        op.add(AbstractBuilder::bytesLimit, JsonpDeserializer.longDeserializer(), "bytes_limit", new String[0]);
        op.add(AbstractBuilder::bytesWanted, JsonpDeserializer.longDeserializer(), "bytes_wanted", new String[0]);
        op.add(AbstractBuilder::column, JsonpDeserializer.integerDeserializer(), "column", new String[0]);
        op.add(AbstractBuilder::col, JsonpDeserializer.integerDeserializer(), "col", new String[0]);
        op.add(AbstractBuilder::failedShards, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failed_shards", new String[0]);
        op.add(AbstractBuilder::grouped, JsonpDeserializer.booleanDeserializer(), "grouped", new String[0]);
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(AbstractBuilder::indexUuid, JsonpDeserializer.stringDeserializer(), "index_uuid", new String[0]);
        op.add(AbstractBuilder::language, JsonpDeserializer.stringDeserializer(), "language", new String[0]);
        op.add(AbstractBuilder::licensedExpiredFeature, JsonpDeserializer.stringDeserializer(), "licensed_expired_feature", new String[0]);
        op.add(AbstractBuilder::line, JsonpDeserializer.integerDeserializer(), "line", new String[0]);
        op.add(AbstractBuilder::maxBuckets, JsonpDeserializer.integerDeserializer(), "max_buckets", new String[0]);
        op.add(AbstractBuilder::phase, JsonpDeserializer.stringDeserializer(), "phase", new String[0]);
        op.add(AbstractBuilder::propertyName, JsonpDeserializer.stringDeserializer(), "property_name", new String[0]);
        op.add(AbstractBuilder::processorType, JsonpDeserializer.stringDeserializer(), "processor_type", new String[0]);
        op.add(AbstractBuilder::resourceId, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "resource_id", "resource.id");
        op.add(AbstractBuilder::resourceType, JsonpDeserializer.stringDeserializer(), "resource_type", "resource.type");
        op.add(AbstractBuilder::script, JsonpDeserializer.stringDeserializer(), "script", new String[0]);
        op.add(AbstractBuilder::scriptStack, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "script_stack", new String[0]);
        op.add(AbstractBuilder::header, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "header", new String[0]);
        op.add(AbstractBuilder::lang, JsonpDeserializer.stringDeserializer(), "lang", new String[0]);
        op.add(AbstractBuilder::position, PainlessExecutionPosition._DESERIALIZER, "position", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private String type;
        private String reason;
        @Nullable
        private ErrorCause causedBy;
        @Nullable
        private String shard;
        @Nullable
        private String stackTrace;
        @Nullable
        private List<ErrorCause> rootCause;
        @Nullable
        private Long bytesLimit;
        @Nullable
        private Long bytesWanted;
        @Nullable
        private Integer column;
        @Nullable
        private Integer col;
        @Nullable
        private List<ShardFailure> failedShards;
        @Nullable
        private Boolean grouped;
        @Nullable
        private String index;
        @Nullable
        private String indexUuid;
        @Nullable
        private String language;
        @Nullable
        private String licensedExpiredFeature;
        @Nullable
        private Integer line;
        @Nullable
        private Integer maxBuckets;
        @Nullable
        private String phase;
        @Nullable
        private String propertyName;
        @Nullable
        private String processorType;
        @Nullable
        private List<String> resourceId;
        @Nullable
        private String resourceType;
        @Nullable
        private String script;
        @Nullable
        private List<String> scriptStack;
        @Nullable
        private Map<String, List<String>> header;
        @Nullable
        private String lang;
        @Nullable
        private PainlessExecutionPosition position;

        protected AbstractBuilder() {
        }

        public BuilderT type(String value) {
            this.type = value;
            return this.self();
        }

        public BuilderT reason(String value) {
            this.reason = value;
            return this.self();
        }

        public BuilderT causedBy(@Nullable ErrorCause value) {
            this.causedBy = value;
            return this.self();
        }

        public BuilderT causedBy(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.causedBy(fn.apply(new Builder()).build());
        }

        public BuilderT shard(@Nullable String value) {
            this.shard = value;
            return this.self();
        }

        public BuilderT stackTrace(@Nullable String value) {
            this.stackTrace = value;
            return this.self();
        }

        public BuilderT rootCause(@Nullable List<ErrorCause> value) {
            this.rootCause = value;
            return this.self();
        }

        public BuilderT rootCause(ErrorCause ... value) {
            this.rootCause = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addRootCause(ErrorCause value) {
            if (this.rootCause == null) {
                this.rootCause = new ArrayList<ErrorCause>();
            }
            this.rootCause.add(value);
            return this.self();
        }

        public BuilderT rootCause(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.rootCause(fn.apply(new Builder()).build());
        }

        public BuilderT addRootCause(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.addRootCause(fn.apply(new Builder()).build());
        }

        public BuilderT bytesLimit(@Nullable Long value) {
            this.bytesLimit = value;
            return this.self();
        }

        public BuilderT bytesWanted(@Nullable Long value) {
            this.bytesWanted = value;
            return this.self();
        }

        public BuilderT column(@Nullable Integer value) {
            this.column = value;
            return this.self();
        }

        public BuilderT col(@Nullable Integer value) {
            this.col = value;
            return this.self();
        }

        public BuilderT failedShards(@Nullable List<ShardFailure> value) {
            this.failedShards = value;
            return this.self();
        }

        public BuilderT failedShards(ShardFailure ... value) {
            this.failedShards = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addFailedShards(ShardFailure value) {
            if (this.failedShards == null) {
                this.failedShards = new ArrayList<ShardFailure>();
            }
            this.failedShards.add(value);
            return this.self();
        }

        public BuilderT failedShards(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failedShards(fn.apply(new ShardFailure.Builder()).build());
        }

        public BuilderT addFailedShards(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.addFailedShards(fn.apply(new ShardFailure.Builder()).build());
        }

        public BuilderT grouped(@Nullable Boolean value) {
            this.grouped = value;
            return this.self();
        }

        public BuilderT index(@Nullable String value) {
            this.index = value;
            return this.self();
        }

        public BuilderT indexUuid(@Nullable String value) {
            this.indexUuid = value;
            return this.self();
        }

        public BuilderT language(@Nullable String value) {
            this.language = value;
            return this.self();
        }

        public BuilderT licensedExpiredFeature(@Nullable String value) {
            this.licensedExpiredFeature = value;
            return this.self();
        }

        public BuilderT line(@Nullable Integer value) {
            this.line = value;
            return this.self();
        }

        public BuilderT maxBuckets(@Nullable Integer value) {
            this.maxBuckets = value;
            return this.self();
        }

        public BuilderT phase(@Nullable String value) {
            this.phase = value;
            return this.self();
        }

        public BuilderT propertyName(@Nullable String value) {
            this.propertyName = value;
            return this.self();
        }

        public BuilderT processorType(@Nullable String value) {
            this.processorType = value;
            return this.self();
        }

        public BuilderT resourceId(@Nullable List<String> value) {
            this.resourceId = value;
            return this.self();
        }

        public BuilderT resourceId(String ... value) {
            this.resourceId = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addResourceId(String value) {
            if (this.resourceId == null) {
                this.resourceId = new ArrayList<String>();
            }
            this.resourceId.add(value);
            return this.self();
        }

        public BuilderT resourceType(@Nullable String value) {
            this.resourceType = value;
            return this.self();
        }

        public BuilderT script(@Nullable String value) {
            this.script = value;
            return this.self();
        }

        public BuilderT scriptStack(@Nullable List<String> value) {
            this.scriptStack = value;
            return this.self();
        }

        public BuilderT scriptStack(String ... value) {
            this.scriptStack = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addScriptStack(String value) {
            if (this.scriptStack == null) {
                this.scriptStack = new ArrayList<String>();
            }
            this.scriptStack.add(value);
            return this.self();
        }

        public BuilderT header(@Nullable Map<String, List<String>> value) {
            this.header = value;
            return this.self();
        }

        public BuilderT putHeader(String key, List<String> value) {
            if (this.header == null) {
                this.header = new HashMap<String, List<String>>();
            }
            this.header.put(key, value);
            return this.self();
        }

        public BuilderT lang(@Nullable String value) {
            this.lang = value;
            return this.self();
        }

        public BuilderT position(@Nullable PainlessExecutionPosition value) {
            this.position = value;
            return this.self();
        }

        public BuilderT position(Function<PainlessExecutionPosition.Builder, ObjectBuilder<PainlessExecutionPosition>> fn) {
            return this.position(fn.apply(new PainlessExecutionPosition.Builder()).build());
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ErrorCause> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ErrorCause build() {
            return new ErrorCause(this);
        }
    }
}

