/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class BaseNode
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final String host;
    private final String ip;
    private final String name;
    @Nullable
    private final List<NodeRole> roles;
    private final String transportAddress;

    public BaseNode(AbstractBuilder<?> builder) {
        this.attributes = ModelTypeHelper.unmodifiableNonNull(((AbstractBuilder)builder).attributes, "attributes");
        this.host = Objects.requireNonNull(((AbstractBuilder)builder).host, "host");
        this.ip = Objects.requireNonNull(((AbstractBuilder)builder).ip, "ip");
        this.name = Objects.requireNonNull(((AbstractBuilder)builder).name, "name");
        this.roles = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).roles);
        this.transportAddress = Objects.requireNonNull(((AbstractBuilder)builder).transportAddress, "transport_address");
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String host() {
        return this.host;
    }

    public String ip() {
        return this.ip;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public List<NodeRole> roles() {
        return this.roles;
    }

    public String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("ip");
        generator.write(this.ip);
        generator.writeKey("name");
        generator.write(this.name);
        if (this.roles != null) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBaseNodeDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
        op.add(AbstractBuilder::host, JsonpDeserializer.stringDeserializer(), "host", new String[0]);
        op.add(AbstractBuilder::ip, JsonpDeserializer.stringDeserializer(), "ip", new String[0]);
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(AbstractBuilder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles", new String[0]);
        op.add(AbstractBuilder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private Map<String, String> attributes;
        private String host;
        private String ip;
        private String name;
        @Nullable
        private List<NodeRole> roles;
        private String transportAddress;

        protected AbstractBuilder() {
        }

        public BuilderT attributes(Map<String, String> value) {
            this.attributes = value;
            return this.self();
        }

        public BuilderT putAttributes(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this.self();
        }

        public BuilderT host(String value) {
            this.host = value;
            return this.self();
        }

        public BuilderT ip(String value) {
            this.ip = value;
            return this.self();
        }

        public BuilderT name(String value) {
            this.name = value;
            return this.self();
        }

        public BuilderT roles(@Nullable List<NodeRole> value) {
            this.roles = value;
            return this.self();
        }

        public BuilderT roles(NodeRole ... value) {
            this.roles = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addRoles(NodeRole value) {
            if (this.roles == null) {
                this.roles = new ArrayList<NodeRole>();
            }
            this.roles.add(value);
            return this.self();
        }

        public BuilderT transportAddress(String value) {
            this.transportAddress = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

