/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.InstanceDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.json.ValueBodyDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonParser;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ObjectBuilderDeserializer<T>
extends JsonpDeserializer<T> {
    private final JsonpDeserializer<? extends ObjectBuilder<T>> builderDeserializer;

    public ObjectBuilderDeserializer(JsonpDeserializer<? extends ObjectBuilder<T>> builderDeserializer) {
        super(builderDeserializer.acceptedEvents());
        this.builderDeserializer = builderDeserializer;
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        ObjectBuilder<T> builder = this.builderDeserializer.deserialize(parser, mapper, event);
        return builder.build();
    }

    public static <T, B extends ObjectBuilder<T>> JsonpDeserializer<T> createForObject(Supplier<B> ctor, Consumer<DelegatingDeserializer<B>> configurer) {
        ObjectDeserializer<B> op = new ObjectDeserializer<B>(ctor);
        configurer.accept(op);
        return new ObjectBuilderDeserializer<T>(op);
    }

    public static <T, B extends ObjectBuilder<T>> InstanceDeserializer<B, B> createForBuilder(Consumer<DelegatingDeserializer<B>> configurer) {
        ObjectDeserializer op = new ObjectDeserializer(null);
        configurer.accept(op);
        return op;
    }

    public static <T, B extends ObjectBuilder<T>> JsonpDeserializer<T> createForValue(Supplier<B> ctor, Consumer<DelegatingDeserializer<B>> configurer) {
        ValueBodyDeserializer<B> op = new ValueBodyDeserializer<B>(ctor);
        configurer.accept(op);
        return new ObjectBuilderDeserializer<T>(op);
    }
}

