/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Audit;
import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.FeatureToggle;
import co.elastic.clients.elasticsearch.xpack.usage.IpFilter;
import co.elastic.clients.elasticsearch.xpack.usage.Realm;
import co.elastic.clients.elasticsearch.xpack.usage.RoleMapping;
import co.elastic.clients.elasticsearch.xpack.usage.SecurityRoles;
import co.elastic.clients.elasticsearch.xpack.usage.Ssl;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Security
extends Base {
    private final FeatureToggle apiKeyService;
    private final FeatureToggle anonymous;
    private final Audit audit;
    private final FeatureToggle fips140;
    private final IpFilter ipfilter;
    private final Map<String, Realm> realms;
    private final Map<String, RoleMapping> roleMapping;
    private final SecurityRoles roles;
    private final Ssl ssl;
    @Nullable
    private final FeatureToggle systemKey;
    private final FeatureToggle tokenService;
    private final Base operatorPrivileges;
    public static final JsonpDeserializer<Security> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Security::setupSecurityDeserializer, Builder::build);

    public Security(Builder builder) {
        super(builder);
        this.apiKeyService = Objects.requireNonNull(builder.apiKeyService, "api_key_service");
        this.anonymous = Objects.requireNonNull(builder.anonymous, "anonymous");
        this.audit = Objects.requireNonNull(builder.audit, "audit");
        this.fips140 = Objects.requireNonNull(builder.fips140, "fips_140");
        this.ipfilter = Objects.requireNonNull(builder.ipfilter, "ipfilter");
        this.realms = ModelTypeHelper.unmodifiableNonNull(builder.realms, "realms");
        this.roleMapping = ModelTypeHelper.unmodifiableNonNull(builder.roleMapping, "role_mapping");
        this.roles = Objects.requireNonNull(builder.roles, "roles");
        this.ssl = Objects.requireNonNull(builder.ssl, "ssl");
        this.systemKey = builder.systemKey;
        this.tokenService = Objects.requireNonNull(builder.tokenService, "token_service");
        this.operatorPrivileges = Objects.requireNonNull(builder.operatorPrivileges, "operator_privileges");
    }

    public Security(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public FeatureToggle apiKeyService() {
        return this.apiKeyService;
    }

    public FeatureToggle anonymous() {
        return this.anonymous;
    }

    public Audit audit() {
        return this.audit;
    }

    public FeatureToggle fips140() {
        return this.fips140;
    }

    public IpFilter ipfilter() {
        return this.ipfilter;
    }

    public Map<String, Realm> realms() {
        return this.realms;
    }

    public Map<String, RoleMapping> roleMapping() {
        return this.roleMapping;
    }

    public SecurityRoles roles() {
        return this.roles;
    }

    public Ssl ssl() {
        return this.ssl;
    }

    @Nullable
    public FeatureToggle systemKey() {
        return this.systemKey;
    }

    public FeatureToggle tokenService() {
        return this.tokenService;
    }

    public Base operatorPrivileges() {
        return this.operatorPrivileges;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("api_key_service");
        this.apiKeyService.serialize(generator, mapper);
        generator.writeKey("anonymous");
        this.anonymous.serialize(generator, mapper);
        generator.writeKey("audit");
        this.audit.serialize(generator, mapper);
        generator.writeKey("fips_140");
        this.fips140.serialize(generator, mapper);
        generator.writeKey("ipfilter");
        this.ipfilter.serialize(generator, mapper);
        generator.writeKey("realms");
        generator.writeStartObject();
        for (Map.Entry<String, Realm> entry : this.realms.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("role_mapping");
        generator.writeStartObject();
        for (Map.Entry<String, JsonpSerializable> entry : this.roleMapping.entrySet()) {
            generator.writeKey(entry.getKey());
            ((RoleMapping)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("roles");
        this.roles.serialize(generator, mapper);
        generator.writeKey("ssl");
        this.ssl.serialize(generator, mapper);
        if (this.systemKey != null) {
            generator.writeKey("system_key");
            this.systemKey.serialize(generator, mapper);
        }
        generator.writeKey("token_service");
        this.tokenService.serialize(generator, mapper);
        generator.writeKey("operator_privileges");
        this.operatorPrivileges.serialize(generator, mapper);
    }

    protected static void setupSecurityDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::apiKeyService, FeatureToggle._DESERIALIZER, "api_key_service", new String[0]);
        op.add(Builder::anonymous, FeatureToggle._DESERIALIZER, "anonymous", new String[0]);
        op.add(Builder::audit, Audit._DESERIALIZER, "audit", new String[0]);
        op.add(Builder::fips140, FeatureToggle._DESERIALIZER, "fips_140", new String[0]);
        op.add(Builder::ipfilter, IpFilter._DESERIALIZER, "ipfilter", new String[0]);
        op.add(Builder::realms, JsonpDeserializer.stringMapDeserializer(Realm._DESERIALIZER), "realms", new String[0]);
        op.add(Builder::roleMapping, JsonpDeserializer.stringMapDeserializer(RoleMapping._DESERIALIZER), "role_mapping", new String[0]);
        op.add(Builder::roles, SecurityRoles._DESERIALIZER, "roles", new String[0]);
        op.add(Builder::ssl, Ssl._DESERIALIZER, "ssl", new String[0]);
        op.add(Builder::systemKey, FeatureToggle._DESERIALIZER, "system_key", new String[0]);
        op.add(Builder::tokenService, FeatureToggle._DESERIALIZER, "token_service", new String[0]);
        op.add(Builder::operatorPrivileges, Base._DESERIALIZER, "operator_privileges", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Security> {
        private FeatureToggle apiKeyService;
        private FeatureToggle anonymous;
        private Audit audit;
        private FeatureToggle fips140;
        private IpFilter ipfilter;
        private Map<String, Realm> realms;
        private Map<String, RoleMapping> roleMapping;
        private SecurityRoles roles;
        private Ssl ssl;
        @Nullable
        private FeatureToggle systemKey;
        private FeatureToggle tokenService;
        private Base operatorPrivileges;

        public Builder apiKeyService(FeatureToggle value) {
            this.apiKeyService = value;
            return this;
        }

        public Builder apiKeyService(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.apiKeyService(fn.apply(new FeatureToggle.Builder()).build());
        }

        public Builder anonymous(FeatureToggle value) {
            this.anonymous = value;
            return this;
        }

        public Builder anonymous(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.anonymous(fn.apply(new FeatureToggle.Builder()).build());
        }

        public Builder audit(Audit value) {
            this.audit = value;
            return this;
        }

        public Builder audit(Function<Audit.Builder, ObjectBuilder<Audit>> fn) {
            return this.audit(fn.apply(new Audit.Builder()).build());
        }

        public Builder fips140(FeatureToggle value) {
            this.fips140 = value;
            return this;
        }

        public Builder fips140(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.fips140(fn.apply(new FeatureToggle.Builder()).build());
        }

        public Builder ipfilter(IpFilter value) {
            this.ipfilter = value;
            return this;
        }

        public Builder ipfilter(Function<IpFilter.Builder, ObjectBuilder<IpFilter>> fn) {
            return this.ipfilter(fn.apply(new IpFilter.Builder()).build());
        }

        public Builder realms(Map<String, Realm> value) {
            this.realms = value;
            return this;
        }

        public Builder putRealms(String key, Realm value) {
            if (this.realms == null) {
                this.realms = new HashMap<String, Realm>();
            }
            this.realms.put(key, value);
            return this;
        }

        public Builder realms(String key, Function<Realm.Builder, ObjectBuilder<Realm>> fn) {
            return this.realms(Collections.singletonMap(key, fn.apply(new Realm.Builder()).build()));
        }

        public Builder putRealms(String key, Function<Realm.Builder, ObjectBuilder<Realm>> fn) {
            return this.putRealms(key, fn.apply(new Realm.Builder()).build());
        }

        public Builder roleMapping(Map<String, RoleMapping> value) {
            this.roleMapping = value;
            return this;
        }

        public Builder putRoleMapping(String key, RoleMapping value) {
            if (this.roleMapping == null) {
                this.roleMapping = new HashMap<String, RoleMapping>();
            }
            this.roleMapping.put(key, value);
            return this;
        }

        public Builder roleMapping(String key, Function<RoleMapping.Builder, ObjectBuilder<RoleMapping>> fn) {
            return this.roleMapping(Collections.singletonMap(key, fn.apply(new RoleMapping.Builder()).build()));
        }

        public Builder putRoleMapping(String key, Function<RoleMapping.Builder, ObjectBuilder<RoleMapping>> fn) {
            return this.putRoleMapping(key, fn.apply(new RoleMapping.Builder()).build());
        }

        public Builder roles(SecurityRoles value) {
            this.roles = value;
            return this;
        }

        public Builder roles(Function<SecurityRoles.Builder, ObjectBuilder<SecurityRoles>> fn) {
            return this.roles(fn.apply(new SecurityRoles.Builder()).build());
        }

        public Builder ssl(Ssl value) {
            this.ssl = value;
            return this;
        }

        public Builder ssl(Function<Ssl.Builder, ObjectBuilder<Ssl>> fn) {
            return this.ssl(fn.apply(new Ssl.Builder()).build());
        }

        public Builder systemKey(@Nullable FeatureToggle value) {
            this.systemKey = value;
            return this;
        }

        public Builder systemKey(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.systemKey(fn.apply(new FeatureToggle.Builder()).build());
        }

        public Builder tokenService(FeatureToggle value) {
            this.tokenService = value;
            return this;
        }

        public Builder tokenService(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.tokenService(fn.apply(new FeatureToggle.Builder()).build());
        }

        public Builder operatorPrivileges(Base value) {
            this.operatorPrivileges = value;
            return this;
        }

        public Builder operatorPrivileges(Function<Base.Builder, ObjectBuilder<Base>> fn) {
            return this.operatorPrivileges(fn.apply(new Base.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Security build() {
            return new Security(this);
        }
    }
}

