/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RuntimeFieldsType
implements JsonpSerializable {
    private final long charsMax;
    private final long charsTotal;
    private final long count;
    private final long docMax;
    private final long docTotal;
    private final long indexCount;
    private final List<String> lang;
    private final long linesMax;
    private final long linesTotal;
    private final String name;
    private final long scriptlessCount;
    private final long shadowedCount;
    private final long sourceMax;
    private final long sourceTotal;
    public static final JsonpDeserializer<RuntimeFieldsType> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeFieldsType::setupRuntimeFieldsTypeDeserializer, Builder::build);

    public RuntimeFieldsType(Builder builder) {
        this.charsMax = Objects.requireNonNull(builder.charsMax, "chars_max");
        this.charsTotal = Objects.requireNonNull(builder.charsTotal, "chars_total");
        this.count = Objects.requireNonNull(builder.count, "count");
        this.docMax = Objects.requireNonNull(builder.docMax, "doc_max");
        this.docTotal = Objects.requireNonNull(builder.docTotal, "doc_total");
        this.indexCount = Objects.requireNonNull(builder.indexCount, "index_count");
        this.lang = ModelTypeHelper.unmodifiableNonNull(builder.lang, "lang");
        this.linesMax = Objects.requireNonNull(builder.linesMax, "lines_max");
        this.linesTotal = Objects.requireNonNull(builder.linesTotal, "lines_total");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.scriptlessCount = Objects.requireNonNull(builder.scriptlessCount, "scriptless_count");
        this.shadowedCount = Objects.requireNonNull(builder.shadowedCount, "shadowed_count");
        this.sourceMax = Objects.requireNonNull(builder.sourceMax, "source_max");
        this.sourceTotal = Objects.requireNonNull(builder.sourceTotal, "source_total");
    }

    public RuntimeFieldsType(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long charsMax() {
        return this.charsMax;
    }

    public long charsTotal() {
        return this.charsTotal;
    }

    public long count() {
        return this.count;
    }

    public long docMax() {
        return this.docMax;
    }

    public long docTotal() {
        return this.docTotal;
    }

    public long indexCount() {
        return this.indexCount;
    }

    public List<String> lang() {
        return this.lang;
    }

    public long linesMax() {
        return this.linesMax;
    }

    public long linesTotal() {
        return this.linesTotal;
    }

    public String name() {
        return this.name;
    }

    public long scriptlessCount() {
        return this.scriptlessCount;
    }

    public long shadowedCount() {
        return this.shadowedCount;
    }

    public long sourceMax() {
        return this.sourceMax;
    }

    public long sourceTotal() {
        return this.sourceTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("chars_max");
        generator.write(this.charsMax);
        generator.writeKey("chars_total");
        generator.write(this.charsTotal);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("doc_max");
        generator.write(this.docMax);
        generator.writeKey("doc_total");
        generator.write(this.docTotal);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("lang");
        generator.writeStartArray();
        for (String item0 : this.lang) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("lines_max");
        generator.write(this.linesMax);
        generator.writeKey("lines_total");
        generator.write(this.linesTotal);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("scriptless_count");
        generator.write(this.scriptlessCount);
        generator.writeKey("shadowed_count");
        generator.write(this.shadowedCount);
        generator.writeKey("source_max");
        generator.write(this.sourceMax);
        generator.writeKey("source_total");
        generator.write(this.sourceTotal);
    }

    protected static void setupRuntimeFieldsTypeDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::charsMax, JsonpDeserializer.longDeserializer(), "chars_max", new String[0]);
        op.add(Builder::charsTotal, JsonpDeserializer.longDeserializer(), "chars_total", new String[0]);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::docMax, JsonpDeserializer.longDeserializer(), "doc_max", new String[0]);
        op.add(Builder::docTotal, JsonpDeserializer.longDeserializer(), "doc_total", new String[0]);
        op.add(Builder::indexCount, JsonpDeserializer.longDeserializer(), "index_count", new String[0]);
        op.add(Builder::lang, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "lang", new String[0]);
        op.add(Builder::linesMax, JsonpDeserializer.longDeserializer(), "lines_max", new String[0]);
        op.add(Builder::linesTotal, JsonpDeserializer.longDeserializer(), "lines_total", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::scriptlessCount, JsonpDeserializer.longDeserializer(), "scriptless_count", new String[0]);
        op.add(Builder::shadowedCount, JsonpDeserializer.longDeserializer(), "shadowed_count", new String[0]);
        op.add(Builder::sourceMax, JsonpDeserializer.longDeserializer(), "source_max", new String[0]);
        op.add(Builder::sourceTotal, JsonpDeserializer.longDeserializer(), "source_total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RuntimeFieldsType> {
        private Long charsMax;
        private Long charsTotal;
        private Long count;
        private Long docMax;
        private Long docTotal;
        private Long indexCount;
        private List<String> lang;
        private Long linesMax;
        private Long linesTotal;
        private String name;
        private Long scriptlessCount;
        private Long shadowedCount;
        private Long sourceMax;
        private Long sourceTotal;

        public Builder charsMax(long value) {
            this.charsMax = value;
            return this;
        }

        public Builder charsTotal(long value) {
            this.charsTotal = value;
            return this;
        }

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder docMax(long value) {
            this.docMax = value;
            return this;
        }

        public Builder docTotal(long value) {
            this.docTotal = value;
            return this;
        }

        public Builder indexCount(long value) {
            this.indexCount = value;
            return this;
        }

        public Builder lang(List<String> value) {
            this.lang = value;
            return this;
        }

        public Builder lang(String ... value) {
            this.lang = Arrays.asList(value);
            return this;
        }

        public Builder addLang(String value) {
            if (this.lang == null) {
                this.lang = new ArrayList<String>();
            }
            this.lang.add(value);
            return this;
        }

        public Builder linesMax(long value) {
            this.linesMax = value;
            return this;
        }

        public Builder linesTotal(long value) {
            this.linesTotal = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder scriptlessCount(long value) {
            this.scriptlessCount = value;
            return this;
        }

        public Builder shadowedCount(long value) {
            this.shadowedCount = value;
            return this;
        }

        public Builder sourceMax(long value) {
            this.sourceMax = value;
            return this;
        }

        public Builder sourceTotal(long value) {
            this.sourceTotal = value;
            return this;
        }

        @Override
        public RuntimeFieldsType build() {
            return new RuntimeFieldsType(this);
        }
    }
}

