/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class IpFilter
implements JsonpSerializable {
    private final boolean http;
    private final boolean transport;
    public static final JsonpDeserializer<IpFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpFilter::setupIpFilterDeserializer, Builder::build);

    public IpFilter(Builder builder) {
        this.http = Objects.requireNonNull(builder.http, "http");
        this.transport = Objects.requireNonNull(builder.transport, "transport");
    }

    public IpFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean http() {
        return this.http;
    }

    public boolean transport() {
        return this.transport;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("http");
        generator.write(this.http);
        generator.writeKey("transport");
        generator.write(this.transport);
    }

    protected static void setupIpFilterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::http, JsonpDeserializer.booleanDeserializer(), "http", new String[0]);
        op.add(Builder::transport, JsonpDeserializer.booleanDeserializer(), "transport", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IpFilter> {
        private Boolean http;
        private Boolean transport;

        public Builder http(boolean value) {
            this.http = value;
            return this;
        }

        public Builder transport(boolean value) {
            this.transport = value;
            return this;
        }

        @Override
        public IpFilter build() {
            return new IpFilter(this);
        }
    }
}

