/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DataTierPhaseStatistics
implements JsonpSerializable {
    private final long nodeCount;
    private final long indexCount;
    private final long totalShardCount;
    private final long primaryShardCount;
    private final long docCount;
    private final long totalSizeBytes;
    private final long primarySizeBytes;
    private final long primaryShardSizeAvgBytes;
    private final long primaryShardSizeMedianBytes;
    private final long primaryShardSizeMadBytes;
    public static final JsonpDeserializer<DataTierPhaseStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataTierPhaseStatistics::setupDataTierPhaseStatisticsDeserializer, Builder::build);

    public DataTierPhaseStatistics(Builder builder) {
        this.nodeCount = Objects.requireNonNull(builder.nodeCount, "node_count");
        this.indexCount = Objects.requireNonNull(builder.indexCount, "index_count");
        this.totalShardCount = Objects.requireNonNull(builder.totalShardCount, "total_shard_count");
        this.primaryShardCount = Objects.requireNonNull(builder.primaryShardCount, "primary_shard_count");
        this.docCount = Objects.requireNonNull(builder.docCount, "doc_count");
        this.totalSizeBytes = Objects.requireNonNull(builder.totalSizeBytes, "total_size_bytes");
        this.primarySizeBytes = Objects.requireNonNull(builder.primarySizeBytes, "primary_size_bytes");
        this.primaryShardSizeAvgBytes = Objects.requireNonNull(builder.primaryShardSizeAvgBytes, "primary_shard_size_avg_bytes");
        this.primaryShardSizeMedianBytes = Objects.requireNonNull(builder.primaryShardSizeMedianBytes, "primary_shard_size_median_bytes");
        this.primaryShardSizeMadBytes = Objects.requireNonNull(builder.primaryShardSizeMadBytes, "primary_shard_size_mad_bytes");
    }

    public DataTierPhaseStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long indexCount() {
        return this.indexCount;
    }

    public long totalShardCount() {
        return this.totalShardCount;
    }

    public long primaryShardCount() {
        return this.primaryShardCount;
    }

    public long docCount() {
        return this.docCount;
    }

    public long totalSizeBytes() {
        return this.totalSizeBytes;
    }

    public long primarySizeBytes() {
        return this.primarySizeBytes;
    }

    public long primaryShardSizeAvgBytes() {
        return this.primaryShardSizeAvgBytes;
    }

    public long primaryShardSizeMedianBytes() {
        return this.primaryShardSizeMedianBytes;
    }

    public long primaryShardSizeMadBytes() {
        return this.primaryShardSizeMadBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_count");
        generator.write(this.nodeCount);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("total_shard_count");
        generator.write(this.totalShardCount);
        generator.writeKey("primary_shard_count");
        generator.write(this.primaryShardCount);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        generator.writeKey("total_size_bytes");
        generator.write(this.totalSizeBytes);
        generator.writeKey("primary_size_bytes");
        generator.write(this.primarySizeBytes);
        generator.writeKey("primary_shard_size_avg_bytes");
        generator.write(this.primaryShardSizeAvgBytes);
        generator.writeKey("primary_shard_size_median_bytes");
        generator.write(this.primaryShardSizeMedianBytes);
        generator.writeKey("primary_shard_size_mad_bytes");
        generator.write(this.primaryShardSizeMadBytes);
    }

    protected static void setupDataTierPhaseStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeCount, JsonpDeserializer.longDeserializer(), "node_count", new String[0]);
        op.add(Builder::indexCount, JsonpDeserializer.longDeserializer(), "index_count", new String[0]);
        op.add(Builder::totalShardCount, JsonpDeserializer.longDeserializer(), "total_shard_count", new String[0]);
        op.add(Builder::primaryShardCount, JsonpDeserializer.longDeserializer(), "primary_shard_count", new String[0]);
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count", new String[0]);
        op.add(Builder::totalSizeBytes, JsonpDeserializer.longDeserializer(), "total_size_bytes", new String[0]);
        op.add(Builder::primarySizeBytes, JsonpDeserializer.longDeserializer(), "primary_size_bytes", new String[0]);
        op.add(Builder::primaryShardSizeAvgBytes, JsonpDeserializer.longDeserializer(), "primary_shard_size_avg_bytes", new String[0]);
        op.add(Builder::primaryShardSizeMedianBytes, JsonpDeserializer.longDeserializer(), "primary_shard_size_median_bytes", new String[0]);
        op.add(Builder::primaryShardSizeMadBytes, JsonpDeserializer.longDeserializer(), "primary_shard_size_mad_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataTierPhaseStatistics> {
        private Long nodeCount;
        private Long indexCount;
        private Long totalShardCount;
        private Long primaryShardCount;
        private Long docCount;
        private Long totalSizeBytes;
        private Long primarySizeBytes;
        private Long primaryShardSizeAvgBytes;
        private Long primaryShardSizeMedianBytes;
        private Long primaryShardSizeMadBytes;

        public Builder nodeCount(long value) {
            this.nodeCount = value;
            return this;
        }

        public Builder indexCount(long value) {
            this.indexCount = value;
            return this;
        }

        public Builder totalShardCount(long value) {
            this.totalShardCount = value;
            return this;
        }

        public Builder primaryShardCount(long value) {
            this.primaryShardCount = value;
            return this;
        }

        public Builder docCount(long value) {
            this.docCount = value;
            return this;
        }

        public Builder totalSizeBytes(long value) {
            this.totalSizeBytes = value;
            return this;
        }

        public Builder primarySizeBytes(long value) {
            this.primarySizeBytes = value;
            return this;
        }

        public Builder primaryShardSizeAvgBytes(long value) {
            this.primaryShardSizeAvgBytes = value;
            return this;
        }

        public Builder primaryShardSizeMedianBytes(long value) {
            this.primaryShardSizeMedianBytes = value;
            return this;
        }

        public Builder primaryShardSizeMadBytes(long value) {
            this.primaryShardSizeMadBytes = value;
            return this;
        }

        @Override
        public DataTierPhaseStatistics build() {
            return new DataTierPhaseStatistics(this);
        }
    }
}

