/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.HttpInputRequestResult;
import co.elastic.clients.elasticsearch.watcher.HttpInputResponseResult;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WebhookResult
implements JsonpSerializable {
    private final HttpInputRequestResult request;
    @Nullable
    private final HttpInputResponseResult response;
    public static final JsonpDeserializer<WebhookResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WebhookResult::setupWebhookResultDeserializer, Builder::build);

    public WebhookResult(Builder builder) {
        this.request = Objects.requireNonNull(builder.request, "request");
        this.response = builder.response;
    }

    public WebhookResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public HttpInputRequestResult request() {
        return this.request;
    }

    @Nullable
    public HttpInputResponseResult response() {
        return this.response;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("request");
        this.request.serialize(generator, mapper);
        if (this.response != null) {
            generator.writeKey("response");
            this.response.serialize(generator, mapper);
        }
    }

    protected static void setupWebhookResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::request, HttpInputRequestResult._DESERIALIZER, "request", new String[0]);
        op.add(Builder::response, HttpInputResponseResult._DESERIALIZER, "response", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WebhookResult> {
        private HttpInputRequestResult request;
        @Nullable
        private HttpInputResponseResult response;

        public Builder request(HttpInputRequestResult value) {
            this.request = value;
            return this;
        }

        public Builder request(Function<HttpInputRequestResult.Builder, ObjectBuilder<HttpInputRequestResult>> fn) {
            return this.request(fn.apply(new HttpInputRequestResult.Builder()).build());
        }

        public Builder response(@Nullable HttpInputResponseResult value) {
            this.response = value;
            return this;
        }

        public Builder response(Function<HttpInputResponseResult.Builder, ObjectBuilder<HttpInputResponseResult>> fn) {
            return this.response(fn.apply(new HttpInputResponseResult.Builder()).build());
        }

        @Override
        public WebhookResult build() {
            return new WebhookResult(this);
        }
    }
}

