/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch.watcher.Action;
import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.Trigger;
import co.elastic.clients.elasticsearch.watcher.WatchStatus;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Watch
implements JsonpSerializable {
    private final Map<String, Action> actions;
    private final Condition condition;
    private final Input input;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final WatchStatus status;
    @Nullable
    private final String throttlePeriod;
    @Nullable
    private final Transform transform;
    private final Trigger trigger;
    @Nullable
    private final Long throttlePeriodInMillis;
    public static final JsonpDeserializer<Watch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Watch::setupWatchDeserializer, Builder::build);

    public Watch(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiableNonNull(builder.actions, "actions");
        this.condition = Objects.requireNonNull(builder.condition, "condition");
        this.input = Objects.requireNonNull(builder.input, "input");
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.status = builder.status;
        this.throttlePeriod = builder.throttlePeriod;
        this.transform = builder.transform;
        this.trigger = Objects.requireNonNull(builder.trigger, "trigger");
        this.throttlePeriodInMillis = builder.throttlePeriodInMillis;
    }

    public Watch(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Action> actions() {
        return this.actions;
    }

    public Condition condition() {
        return this.condition;
    }

    public Input input() {
        return this.input;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public WatchStatus status() {
        return this.status;
    }

    @Nullable
    public String throttlePeriod() {
        return this.throttlePeriod;
    }

    @Nullable
    public Transform transform() {
        return this.transform;
    }

    public Trigger trigger() {
        return this.trigger;
    }

    @Nullable
    public Long throttlePeriodInMillis() {
        return this.throttlePeriodInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.writeStartObject();
        for (Map.Entry<String, Action> entry : this.actions.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("condition");
        this.condition.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        if (this.throttlePeriod != null) {
            generator.writeKey("throttle_period");
            generator.write(this.throttlePeriod);
        }
        if (this.transform != null) {
            generator.writeKey("transform");
            this.transform.serialize(generator, mapper);
        }
        generator.writeKey("trigger");
        this.trigger.serialize(generator, mapper);
        if (this.throttlePeriodInMillis != null) {
            generator.writeKey("throttle_period_in_millis");
            generator.write(this.throttlePeriodInMillis.longValue());
        }
    }

    protected static void setupWatchDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(Action._DESERIALIZER), "actions", new String[0]);
        op.add(Builder::condition, Condition._DESERIALIZER, "condition", new String[0]);
        op.add(Builder::input, Input._DESERIALIZER, "input", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::status, WatchStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::throttlePeriod, JsonpDeserializer.stringDeserializer(), "throttle_period", new String[0]);
        op.add(Builder::transform, Transform._DESERIALIZER, "transform", new String[0]);
        op.add(Builder::trigger, Trigger._DESERIALIZER, "trigger", new String[0]);
        op.add(Builder::throttlePeriodInMillis, JsonpDeserializer.longDeserializer(), "throttle_period_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Watch> {
        private Map<String, Action> actions;
        private Condition condition;
        private Input input;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private WatchStatus status;
        @Nullable
        private String throttlePeriod;
        @Nullable
        private Transform transform;
        private Trigger trigger;
        @Nullable
        private Long throttlePeriodInMillis;

        public Builder actions(Map<String, Action> value) {
            this.actions = value;
            return this;
        }

        public Builder putActions(String key, Action value) {
            if (this.actions == null) {
                this.actions = new HashMap<String, Action>();
            }
            this.actions.put(key, value);
            return this;
        }

        public Builder actions(String key, Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.actions(Collections.singletonMap(key, fn.apply(new Action.Builder()).build()));
        }

        public Builder putActions(String key, Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.putActions(key, fn.apply(new Action.Builder()).build());
        }

        public Builder condition(Condition value) {
            this.condition = value;
            return this;
        }

        public Builder condition(Function<Condition.Builder, ObjectBuilder<Condition>> fn) {
            return this.condition(fn.apply(new Condition.Builder()).build());
        }

        public Builder input(Input value) {
            this.input = value;
            return this;
        }

        public Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder status(@Nullable WatchStatus value) {
            this.status = value;
            return this;
        }

        public Builder status(Function<WatchStatus.Builder, ObjectBuilder<WatchStatus>> fn) {
            return this.status(fn.apply(new WatchStatus.Builder()).build());
        }

        public Builder throttlePeriod(@Nullable String value) {
            this.throttlePeriod = value;
            return this;
        }

        public Builder transform(@Nullable Transform value) {
            this.transform = value;
            return this;
        }

        public Builder transform(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.transform(fn.apply(new Transform.Builder()).build());
        }

        public Builder trigger(Trigger value) {
            this.trigger = value;
            return this;
        }

        public Builder trigger(Function<Trigger.Builder, ObjectBuilder<Trigger>> fn) {
            return this.trigger(fn.apply(new Trigger.Builder()).build());
        }

        public Builder throttlePeriodInMillis(@Nullable Long value) {
            this.throttlePeriodInMillis = value;
            return this;
        }

        @Override
        public Watch build() {
            return new Watch(this);
        }
    }
}

