/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.elasticsearch.watcher.SearchInputRequestDefinition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SearchInput
implements InputVariant,
JsonpSerializable {
    @Nullable
    private final List<String> extract;
    private final SearchInputRequestDefinition request;
    @Nullable
    private final String timeout;
    public static final JsonpDeserializer<SearchInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchInput::setupSearchInputDeserializer, Builder::build);

    public SearchInput(Builder builder) {
        this.extract = ModelTypeHelper.unmodifiable(builder.extract);
        this.request = Objects.requireNonNull(builder.request, "request");
        this.timeout = builder.timeout;
    }

    public SearchInput(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "search";
    }

    @Nullable
    public List<String> extract() {
        return this.extract;
    }

    public SearchInputRequestDefinition request() {
        return this.request;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.extract != null) {
            generator.writeKey("extract");
            generator.writeStartArray();
            for (String item0 : this.extract) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("request");
        this.request.serialize(generator, mapper);
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
    }

    protected static void setupSearchInputDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::extract, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extract", new String[0]);
        op.add(Builder::request, SearchInputRequestDefinition._DESERIALIZER, "request", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SearchInput> {
        @Nullable
        private List<String> extract;
        private SearchInputRequestDefinition request;
        @Nullable
        private String timeout;

        public Builder extract(@Nullable List<String> value) {
            this.extract = value;
            return this;
        }

        public Builder extract(String ... value) {
            this.extract = Arrays.asList(value);
            return this;
        }

        public Builder addExtract(String value) {
            if (this.extract == null) {
                this.extract = new ArrayList<String>();
            }
            this.extract.add(value);
            return this;
        }

        public Builder request(SearchInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public Builder request(Function<SearchInputRequestDefinition.Builder, ObjectBuilder<SearchInputRequestDefinition>> fn) {
            return this.request(fn.apply(new SearchInputRequestDefinition.Builder()).build());
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public SearchInput build() {
            return new SearchInput(this);
        }
    }
}

