/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.TriggerEventVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ScheduleTriggerEvent
implements TriggerEventVariant,
JsonpSerializable {
    private final String scheduledTime;
    @Nullable
    private final String triggeredTime;
    public static final JsonpDeserializer<ScheduleTriggerEvent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScheduleTriggerEvent::setupScheduleTriggerEventDeserializer, Builder::build);

    public ScheduleTriggerEvent(Builder builder) {
        this.scheduledTime = Objects.requireNonNull(builder.scheduledTime, "scheduled_time");
        this.triggeredTime = builder.triggeredTime;
    }

    public ScheduleTriggerEvent(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "schedule";
    }

    public String scheduledTime() {
        return this.scheduledTime;
    }

    @Nullable
    public String triggeredTime() {
        return this.triggeredTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("scheduled_time");
        generator.write(this.scheduledTime);
        if (this.triggeredTime != null) {
            generator.writeKey("triggered_time");
            generator.write(this.triggeredTime);
        }
    }

    protected static void setupScheduleTriggerEventDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::scheduledTime, JsonpDeserializer.stringDeserializer(), "scheduled_time", new String[0]);
        op.add(Builder::triggeredTime, JsonpDeserializer.stringDeserializer(), "triggered_time", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ScheduleTriggerEvent> {
        private String scheduledTime;
        @Nullable
        private String triggeredTime;

        public Builder scheduledTime(String value) {
            this.scheduledTime = value;
            return this;
        }

        public Builder triggeredTime(@Nullable String value) {
            this.triggeredTime = value;
            return this;
        }

        @Override
        public ScheduleTriggerEvent build() {
            return new ScheduleTriggerEvent(this);
        }
    }
}

