/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Logging
implements JsonpSerializable {
    @Nullable
    private final String level;
    private final String text;
    @Nullable
    private final String category;
    public static final JsonpDeserializer<Logging> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Logging::setupLoggingDeserializer, Builder::build);

    public Logging(Builder builder) {
        this.level = builder.level;
        this.text = Objects.requireNonNull(builder.text, "text");
        this.category = builder.category;
    }

    public Logging(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String level() {
        return this.level;
    }

    public String text() {
        return this.text;
    }

    @Nullable
    public String category() {
        return this.category;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.level != null) {
            generator.writeKey("level");
            generator.write(this.level);
        }
        generator.writeKey("text");
        generator.write(this.text);
        if (this.category != null) {
            generator.writeKey("category");
            generator.write(this.category);
        }
    }

    protected static void setupLoggingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::level, JsonpDeserializer.stringDeserializer(), "level", new String[0]);
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text", new String[0]);
        op.add(Builder::category, JsonpDeserializer.stringDeserializer(), "category", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Logging> {
        @Nullable
        private String level;
        private String text;
        @Nullable
        private String category;

        public Builder level(@Nullable String value) {
            this.level = value;
            return this;
        }

        public Builder text(String value) {
            this.text = value;
            return this;
        }

        public Builder category(@Nullable String value) {
            this.category = value;
            return this;
        }

        @Override
        public Logging build() {
            return new Logging(this);
        }
    }
}

