/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexResultSummary
implements JsonpSerializable {
    private final boolean created;
    private final String id;
    private final String index;
    private final Result result;
    private final long version;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<IndexResultSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexResultSummary::setupIndexResultSummaryDeserializer, Builder::build);

    public IndexResultSummary(Builder builder) {
        this.created = Objects.requireNonNull(builder.created, "created");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.result = Objects.requireNonNull(builder.result, "result");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.type = builder.type;
    }

    public IndexResultSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean created() {
        return this.created;
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    public Result result() {
        return this.result;
    }

    public long version() {
        return this.version;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("created");
        generator.write(this.created);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("result");
        this.result.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    protected static void setupIndexResultSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::created, JsonpDeserializer.booleanDeserializer(), "created", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::result, Result._DESERIALIZER, "result", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexResultSummary> {
        private Boolean created;
        private String id;
        private String index;
        private Result result;
        private Long version;
        @Nullable
        private String type;

        public Builder created(boolean value) {
            this.created = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder result(Result value) {
            this.result = value;
            return this;
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        public IndexResultSummary build() {
            return new IndexResultSummary(this);
        }
    }
}

