/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ActionWebhook
implements JsonpSerializable {
    private final String host;
    private final int port;
    public static final JsonpDeserializer<ActionWebhook> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ActionWebhook::setupActionWebhookDeserializer, Builder::build);

    public ActionWebhook(Builder builder) {
        this.host = Objects.requireNonNull(builder.host, "host");
        this.port = Objects.requireNonNull(builder.port, "port");
    }

    public ActionWebhook(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("port");
        generator.write(this.port);
    }

    protected static void setupActionWebhookDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", new String[0]);
        op.add(Builder::port, JsonpDeserializer.integerDeserializer(), "port", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ActionWebhook> {
        private String host;
        private Integer port;

        public Builder host(String value) {
            this.host = value;
            return this;
        }

        public Builder port(int value) {
            this.port = value;
            return this;
        }

        @Override
        public ActionWebhook build() {
            return new ActionWebhook(this);
        }
    }
}

